/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import morbid.BrokeredObject;
import morbid.IEnemySelectionStrategy;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.Utils;

class NearestEnemySelectionStrategy
extends BrokeredObject
implements IEnemySelectionStrategy {
    private IRobotPositionManager.ITrackedRobot m_enemy;
    private static final long MAX_ENEMY_NOUPDATE_AGE = 10L;
    private static final double DISTANCE_GAP_FACTOR = 10.0;

    public NearestEnemySelectionStrategy(IRobotController controller) {
        super("ENEMY_STRATEGY", controller);
    }

    public IRobotPositionManager.ITrackedRobot selectEnemy() {
        long time = this.m_robot.getTime();
        if (!this.isUpdated()) {
            this.markAsUpdated();
            IRobotPositionManager.ITrackedRobot[] enemies = this.m_controller.getRobotPositionManager().getKnownAliveObjects();
            switch (enemies.length) {
                case 0: {
                    this.m_enemy = null;
                    break;
                }
                case 1: {
                    this.m_enemy = enemies[0];
                    break;
                }
                default: {
                    double min_distance = Double.MAX_VALUE;
                    int e = 0;
                    while (e < enemies.length) {
                        double distance;
                        IRobotPositionManager.ITrackedRobot enemy = enemies[e];
                        if (time - enemy.getUpdateTime() < 10L && (distance = Utils.relativeDistance(this.m_robot.getX(), this.m_robot.getY(), enemy.getX(), enemy.getY())) < min_distance - 10.0) {
                            min_distance = distance;
                            this.m_enemy = enemy;
                        }
                        ++e;
                    }
                    break block0;
                }
            }
        }
        return this.m_enemy;
    }

    protected void activate() {
        super.activate();
        this.m_enemy = null;
    }

    protected void passivate() {
        this.m_enemy = null;
        super.passivate();
    }

    protected double bid() {
        return 0.0;
    }
}

