/*
 * Decompiled with CFR 0.152.
 */
package edu.wlu.cs.levy.CG;

import edu.wlu.cs.levy.CG.HPoint;

class HRect {
    protected HPoint min;
    protected HPoint max;

    protected HRect(int ndims) {
        this.min = new HPoint(ndims);
        this.max = new HPoint(ndims);
    }

    protected HRect(HPoint vmin, HPoint vmax) {
        this.min = (HPoint)vmin.clone();
        this.max = (HPoint)vmax.clone();
    }

    protected Object clone() {
        return new HRect(this.min, this.max);
    }

    protected HPoint closest(HPoint t) {
        HPoint p = new HPoint(t.coord.length);
        int i = 0;
        while (i < t.coord.length) {
            p.coord[i] = t.coord[i] <= this.min.coord[i] ? this.min.coord[i] : (t.coord[i] >= this.max.coord[i] ? this.max.coord[i] : t.coord[i]);
            ++i;
        }
        return p;
    }

    protected static HRect infiniteHRect(int d) {
        HPoint vmin = new HPoint(d);
        HPoint vmax = new HPoint(d);
        int i = 0;
        while (i < d) {
            vmin.coord[i] = Double.NEGATIVE_INFINITY;
            vmax.coord[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        return new HRect(vmin, vmax);
    }

    protected HRect intersection(HRect r) {
        HPoint newmin = new HPoint(this.min.coord.length);
        HPoint newmax = new HPoint(this.min.coord.length);
        int i = 0;
        while (i < this.min.coord.length) {
            newmin.coord[i] = Math.max(this.min.coord[i], r.min.coord[i]);
            newmax.coord[i] = Math.min(this.max.coord[i], r.max.coord[i]);
            if (newmin.coord[i] >= newmax.coord[i]) {
                return null;
            }
            ++i;
        }
        return new HRect(newmin, newmax);
    }

    protected double area() {
        double a = 1.0;
        int i = 0;
        while (i < this.min.coord.length) {
            a *= this.max.coord[i] - this.min.coord[i];
            ++i;
        }
        return a;
    }

    public String toString() {
        return this.min + "\n" + this.max + "\n";
    }
}

