/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.modifier;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.event.Painter;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.gfws.FactorArrays;
import xander.gfws.distributer.WeightDistributer;
import xander.gfws.modifier.FactorArrayModifier;

public abstract class AbstractFactorArrayModifier
implements FactorArrayModifier,
Painter {
    protected RobotProxy robotProxy;
    private WeightDistributer weightDistributer;
    private SnapshotHistory snapshotHistory;
    private double weight;
    private Map<Wave, Double> indicies = new HashMap<Wave, Double>();
    int arraySize;
    private boolean paint;

    public AbstractFactorArrayModifier(WeightDistributer weightDistributer, double weight) {
        this.weightDistributer = weightDistributer;
        this.weight = weight;
        this.robotProxy = Resources.getRobotProxy();
        this.snapshotHistory = Resources.getSnapshotHistory();
        Resources.getRobotEvents().addPainter(this);
    }

    public void setWeightDistributer(WeightDistributer weightDistributer) {
        this.weightDistributer = weightDistributer;
    }

    @Override
    public void setPaint(boolean paint) {
        this.paint = paint;
    }

    protected abstract double getPreciseModifyIndex(double[] var1, Wave var2);

    @Override
    public void modify(double[] array, Wave wave) {
        this.arraySize = array.length;
        double preciseIndex = this.getPreciseModifyIndex(array, wave);
        if (preciseIndex >= 0.0) {
            this.indicies.put(wave, preciseIndex);
            Snapshot defender = this.snapshotHistory.getSnapshot(wave.getInitialDefenderSnapshot().getName());
            double distance = RCMath.getDistanceBetweenPoints(wave.getOriginX(), wave.getOriginY(), defender.getX(), defender.getY());
            this.weightDistributer.addWeight(array, preciseIndex, this.weight, distance, wave.getBulletVelocity(), wave.getSurfDirection());
        }
    }

    @Override
    public void onPaint(Graphics2D g) {
        if (!this.paint) {
            return;
        }
        if (Resources.getTime() < 3L) {
            this.indicies.clear();
        }
        ArrayList<Wave> expired = new ArrayList<Wave>();
        for (Wave wave : this.indicies.keySet()) {
            if (!wave.isPassed()) continue;
            expired.add(wave);
        }
        for (Wave wave : expired) {
            this.indicies.remove(wave);
        }
        g.setColor(Color.RED);
        Stroke stroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        for (Map.Entry<Wave, Double> entry : this.indicies.entrySet()) {
            Wave wave = entry.getKey();
            double pIndex = entry.getValue();
            double d0 = wave.getBulletTravelDistance(Resources.getTime());
            double d1 = d0 + 5.0 + this.weight * 20.0;
            double factorAngle = FactorArrays.getFactorAngle(pIndex, this.arraySize, wave.getBulletVelocity(), wave.getSurfDirection());
            double angle = RCMath.normalizeDegrees(wave.getInitialDefenderBearing() + factorAngle);
            Point2D.Double p0 = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), d0, angle);
            Point2D.Double p1 = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), d1, angle);
            Line2D.Double line = new Line2D.Double(p0, p1);
            g.draw(line);
        }
        if (stroke != null) {
            g.setStroke(stroke);
        }
    }
}

