/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.modifier;

import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.Linear;
import xander.core.math.RCMath;
import xander.core.math.VelocityVector;
import xander.core.track.Wave;
import xander.gfws.FactorArrays;
import xander.gfws.distributer.WaveDistributer;
import xander.gfws.distributer.WeightDistributer;
import xander.gfws.modifier.AbstractFactorArrayModifier;

public class LinearFactorArrayModifier
extends AbstractFactorArrayModifier {
    private static final Log log = Logger.getLog(LinearFactorArrayModifier.class);

    public LinearFactorArrayModifier(double weight) {
        this(new WaveDistributer(), weight);
    }

    public LinearFactorArrayModifier(WeightDistributer weightDistributer, double weight) {
        super(weightDistributer, weight);
    }

    @Override
    protected double getPreciseModifyIndex(double[] array, Wave wave) {
        VelocityVector vv = Linear.calculateTrajectory(wave.getInitialDefenderSnapshot(), wave.getOriginX(), wave.getOriginY(), wave.getBulletVelocity(), this.robotProxy.getBattleFieldSize(), wave.getOriginTime());
        if (vv == null) {
            log.warn("Unable to calculate linear trajectory for bullet.");
            return array.length - 1;
        }
        double factorAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), vv.getRoboAngle());
        double preciseModifyIndex = FactorArrays.getPreciseFactorIndex(factorAngle, array.length, wave.getBulletVelocity(), wave.getSurfDirection());
        return preciseModifyIndex;
    }
}

