/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.layer.TargetLayer;
import dmonner.xlbp.util.MatrixTools;
import java.text.DecimalFormat;

public class Target {
    private static final DecimalFormat df = new DecimalFormat("0.000");
    private final TargetLayer layer;
    private final float[] value;
    private float weight;

    public Target(TargetLayer layer, float[] value) {
        this(layer, value, 1.0f);
    }

    public Target(TargetLayer layer, float[] value, float weight) {
        this.layer = layer;
        this.value = value;
        this.weight = weight;
        if (value.length != layer.size()) {
            throw new IllegalArgumentException("Incorrect Target Size; expected " + layer.size() + " for " + layer.getName() + ", got " + value.length);
        }
    }

    public void apply() {
        this.layer.setTarget(this.value, this.weight);
    }

    public TargetLayer getLayer() {
        return this.layer;
    }

    public float[] getValue() {
        return this.value;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public String toString() {
        return this.layer.getName() + "(" + df.format(this.weight) + "): " + MatrixTools.toString(this.value);
    }
}

