/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.layer.AbstractInternalLayer;
import dmonner.xlbp.layer.FunctionLayer;
import dmonner.xlbp.util.MatrixTools;

public abstract class AbstractFunctionLayer
extends AbstractInternalLayer
implements FunctionLayer {
    private static final long serialVersionUID = 1L;
    protected float[] x;
    protected float[] fprime;

    public AbstractFunctionLayer(AbstractFunctionLayer that, NetworkCopier copier) {
        super(that, copier);
        if (that.x != null) {
            float[] fArray = this.x = copier.copyState() ? MatrixTools.copy(that.x) : MatrixTools.empty(that.x);
        }
        if (that.fprime != null) {
            this.fprime = copier.copyState() ? MatrixTools.copy(that.fprime) : MatrixTools.empty(that.fprime);
        }
    }

    public AbstractFunctionLayer(String name, int size) {
        super(name, size);
    }

    @Override
    public void activateTest() {
        for (int j = 0; j < this.size; ++j) {
            this.y[j] = this.f(j);
        }
    }

    @Override
    public void activateTrain() {
        this.activateTest();
        for (int j = 0; j < this.size; ++j) {
            this.fprime[j] = this.fprime(j);
        }
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.upstream.build();
            this.x = this.upstream.getActivations();
            this.y = new float[this.size];
            this.fprime = new float[this.size];
            this.d = new Responsibilities(this.size);
            this.built = true;
        }
    }

    @Override
    public abstract AbstractFunctionLayer copy(NetworkCopier var1);

    @Override
    public AbstractFunctionLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (sb.showExtra()) {
            sb.appendln("FPrime:");
            sb.pushIndent();
            sb.appendln(MatrixTools.toString(this.fprime));
            sb.popIndent();
        }
        sb.popIndent();
    }

    @Override
    public void updateEligibilities() {
        if (this.downstreamCopyLayer != null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
        }
    }

    @Override
    public void updateResponsibilities() {
        if (this.downstreamCopyLayer == null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
        }
    }

    @Override
    public void updateUpstreamResponsibilities(int index) {
        this.upstream.getResponsibilities(this.myIndexInUpstream).copyMul(this.d, this.fprime);
    }
}

