/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.layer.Layer;
import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.BitDistStat;
import dmonner.xlbp.stat.BitStat;
import dmonner.xlbp.stat.ErrorStat;
import dmonner.xlbp.stat.FractionStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class TargetStat
extends AbstractStat {
    private final String name;
    private final Layer layer;
    private final BitStat bits;
    private final BitDistStat dist;
    private final ErrorStat error;
    private final FractionStat correct;

    public TargetStat(Layer layer) {
        this(layer.getName(), layer);
    }

    public TargetStat(String name, Layer layer) {
        this.name = name;
        this.layer = layer;
        this.bits = new BitStat(name);
        this.dist = new BitDistStat(name, layer.size());
        this.error = new ErrorStat(name);
        this.correct = new FractionStat(name);
    }

    public TargetStat(TargetStat that) {
        this.name = that.name;
        this.layer = that.layer;
        this.bits = new BitStat(that.bits);
        this.dist = new BitDistStat(that.dist);
        this.error = new ErrorStat(that.error);
        this.correct = new FractionStat(that.correct);
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof TargetStat)) {
            throw new IllegalArgumentException("Can only add in other TargetStats.");
        }
        this.add((TargetStat)that);
    }

    public void add(TargetStat that) {
        if (this.layer != that.layer) {
            throw new IllegalArgumentException("Can only add in TargetStats that share a Layer.");
        }
        this.bits.add(that.bits);
        this.dist.add(that.dist);
        this.error.add(that.error);
        this.correct.add(that.correct);
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        this.correct.addTo(prefix, map);
        this.bits.addTo(prefix, map);
        this.dist.addTo(prefix, map);
        this.error.addTo(prefix, map);
    }

    @Override
    public void analyze() {
        this.bits.analyze();
        this.dist.analyze();
        this.error.analyze();
        this.correct.analyze();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.dist.clear();
        this.error.clear();
        this.correct.clear();
    }

    public void compare(float[] target) {
        float[] output = this.layer.getActivations();
        this.bits.compare(target, output);
        this.dist.compare(target, output);
        this.error.compare(target, output);
        this.bits.analyze();
        boolean possible = true;
        this.correct.add(this.bits.getIncorrect() == 0 ? 1 : 0, 1);
    }

    public BitStat getBits() {
        return this.bits;
    }

    public FractionStat getCorrect() {
        return this.correct;
    }

    public BitDistStat getDist() {
        return this.dist;
    }

    public ErrorStat getError() {
        return this.error;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        this.correct.saveData(out);
        this.bits.saveData(out);
        this.dist.saveData(out);
        this.error.saveData(out);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        this.correct.saveHeader(prefix, out);
        this.bits.saveHeader(prefix, out);
        this.dist.saveHeader(prefix, out);
        this.error.saveHeader(prefix, out);
    }

    @Override
    public String toString(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.correct.toString(prefix));
        sb.append(this.bits.toString(prefix));
        sb.append(this.dist.toString(prefix));
        sb.append(this.error.toString(prefix));
        return sb.toString();
    }
}

