/*
 * Decompiled with CFR 0.152.
 */
package kid.data;

import java.util.Collection;
import kid.data.RobotChooser;
import kid.robot.EnemyData;
import kid.robot.RobotData;
import kid.robot.TeammateData;
import kid.utils.Utils;
import robocode.Robot;

public class Easiest
extends RobotChooser {
    private static final double CLOSER_MARGEN = 1.0;

    @Override
    protected RobotData getRobotOverride(Robot myRobot, Collection<RobotData> robots) {
        RobotData robot = this.lastRobot;
        double rating = this.getRating(myRobot, robot);
        for (RobotData r : robots) {
            double ratingTemp;
            if (r.isDead() || !((ratingTemp = this.getRating(myRobot, r)) < rating * 1.0)) continue;
            robot = r;
            rating = ratingTemp;
        }
        return robot;
    }

    @Override
    protected EnemyData getEnemyOverride(Robot myRobot, Collection<EnemyData> enemys) {
        EnemyData enemy = this.lastEnemy;
        double rating = this.getRating(myRobot, enemy);
        for (EnemyData e : enemys) {
            double ratingTemp;
            if (e.isDead() || !((ratingTemp = this.getRating(myRobot, e)) < rating * 1.0)) continue;
            enemy = e;
            rating = ratingTemp;
        }
        return enemy;
    }

    @Override
    protected TeammateData getTeammateOverride(Robot myRobot, Collection<TeammateData> teammates) {
        TeammateData teammate = this.lastTeammate;
        double rating = this.getRating(myRobot, teammate);
        for (TeammateData t : teammates) {
            double ratingTemp;
            if (t.isDead() || !((ratingTemp = this.getRating(myRobot, t)) < rating * 1.0)) continue;
            teammate = t;
            rating = ratingTemp;
        }
        return teammate;
    }

    private double getRating(Robot myRobot, RobotData robot) {
        if (robot.isDead()) {
            return Double.POSITIVE_INFINITY;
        }
        return robot.getEnergy() + Utils.dist(myRobot.getX(), myRobot.getY(), robot.getX(), robot.getY());
    }
}

