/*
 * Decompiled with CFR 0.152.
 */
package kid.management;

import java.util.HashMap;
import kid.communication.Message;
import kid.communication.RobotMessage;
import kid.communication.ScannedRobotMessage;
import kid.data.Drawable;
import kid.data.RobotChooser;
import kid.graphics.RGraphics;
import kid.robot.EnemyData;
import kid.robot.RobotData;
import kid.robot.TeammateData;
import robocode.DeathEvent;
import robocode.Event;
import robocode.MessageEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

public class RobotManager
implements Drawable {
    private Robot robot;
    private static HashMap<String, RobotData> robots;
    private static HashMap<String, EnemyData> enemies;
    private static HashMap<String, TeammateData> teammates;

    public RobotManager(Robot myRobot) {
        this.init(myRobot);
    }

    private void init(Robot myRobot) {
        this.robot = myRobot;
        if (robots == null) {
            TeamRobot teamRobot;
            robots = new HashMap(this.robot.getOthers());
            teammates = new HashMap(0);
            enemies = new HashMap(this.robot.getOthers());
            if (myRobot instanceof TeamRobot && (teamRobot = (TeamRobot)myRobot).getTeammates() != null) {
                teammates = new HashMap(teamRobot.getTeammates().length);
                enemies = new HashMap(this.robot.getOthers() - teamRobot.getTeammates().length);
            }
        } else {
            for (RobotData r : robots.values()) {
                r.setDeath();
            }
        }
    }

    public void inEvent(Event event) {
        if (event instanceof ScannedRobotEvent) {
            this.handleScannedRobot(new ScannedRobotMessage((ScannedRobotEvent)event, this.robot));
        } else if (event instanceof RobotDeathEvent) {
            this.handleRobotDeath((RobotDeathEvent)event);
        } else if (event instanceof DeathEvent) {
            this.handleDeath((DeathEvent)event);
        } else if (event instanceof WinEvent) {
            this.handleWin((WinEvent)event);
        } else if (event instanceof MessageEvent) {
            this.handleMessage((MessageEvent)event);
        }
    }

    private void inMessage(Message message) {
        if (message instanceof ScannedRobotMessage) {
            this.handleScannedRobot((ScannedRobotMessage)message);
        } else if (message instanceof RobotMessage) {
            this.handleRobotMessage((RobotMessage)message);
        }
    }

    private void handleScannedRobot(ScannedRobotMessage srm) {
        RobotData r = this.getRobot(srm.getName());
        if (!r.isDummy()) {
            r.update(srm, this.robot);
        } else if (!srm.getName().equals(this.robot.getName())) {
            TeamRobot teamRobot;
            boolean isEnemy = true;
            if (this.robot instanceof TeamRobot && (teamRobot = (TeamRobot)this.robot).isTeammate(srm.getName())) {
                TeammateData t = new TeammateData(srm, this.robot);
                teammates.put(t.getName(), t);
                robots.put(t.getName(), t);
                isEnemy = false;
            }
            if (isEnemy) {
                EnemyData e = new EnemyData(srm, this.robot);
                enemies.put(e.getName(), e);
                robots.put(e.getName(), e);
            }
        }
    }

    private void handleRobotMessage(RobotMessage rm) {
        RobotData r = this.getRobot(rm.getName());
        if (!r.isDummy()) {
            r.update(rm, this.robot);
        }
    }

    private void handleRobotDeath(RobotDeathEvent rde) {
        if (rde != null) {
            this.getRobot(rde.getName()).setDeath();
        }
    }

    private void handleDeath(DeathEvent de) {
        for (RobotData r : robots.values()) {
            r.setDeath();
        }
    }

    private void handleWin(WinEvent we) {
        for (RobotData r : robots.values()) {
            r.setDeath();
        }
    }

    private void handleMessage(MessageEvent me) {
        if (me.getMessage() instanceof Message) {
            this.inMessage((Message)me.getMessage());
        }
    }

    public RobotData[] getRobots() {
        return robots.values().toArray(new RobotData[0]);
    }

    public RobotData[] getAliveRobots() {
        RobotData[] aliveRobots = new RobotData[this.numAliveRobots()];
        int i = 0;
        for (RobotData r : robots.values()) {
            if (r.isDead()) continue;
            aliveRobots[i++] = r;
        }
        return aliveRobots;
    }

    public int numAliveRobots() {
        int num = 0;
        for (RobotData r : robots.values()) {
            if (r.isDead()) continue;
            ++num;
        }
        return num;
    }

    public EnemyData[] getEnemies() {
        return enemies.values().toArray(new EnemyData[0]);
    }

    public EnemyData[] getAliveEnemies() {
        EnemyData[] aliveEnemies = new EnemyData[this.numAliveEnemies()];
        int i = 0;
        for (EnemyData e : enemies.values()) {
            if (e.isDead()) continue;
            aliveEnemies[i++] = e;
        }
        return aliveEnemies;
    }

    public int numAliveEnemies() {
        int num = 0;
        for (EnemyData e : enemies.values()) {
            if (e.isDead()) continue;
            ++num;
        }
        return num;
    }

    public TeammateData[] getTeammates() {
        return teammates.values().toArray(new TeammateData[0]);
    }

    public RobotData getRobot(RobotChooser chooser) {
        return chooser.getRobot(this.robot, robots.values());
    }

    public EnemyData getEnemy(RobotChooser chooser) {
        return chooser.getEnemy(this.robot, enemies.values());
    }

    public TeammateData getTeammate(RobotChooser chooser) {
        return chooser.getTeammate(this.robot, teammates.values());
    }

    public RobotData getRobot(String name) {
        RobotData robot = robots.get(name);
        return robot != null ? robot : new RobotData();
    }

    public EnemyData getEnemy(String name) {
        EnemyData enemy = enemies.get(name);
        return enemy != null ? enemy : new EnemyData();
    }

    public TeammateData getTeammate(String name) {
        TeammateData teammate = teammates.get(name);
        return teammate != null ? teammate : new TeammateData();
    }

    @Override
    public void draw(RGraphics grid) {
        RobotData[] robotDataArray = this.getRobots();
        int n = robotDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = robotDataArray[n2];
            r.draw(grid);
            ++n2;
        }
    }
}

