/*
 * Decompiled with CFR 0.152.
 */
package eem.motion;

import eem.EvBot;
import eem.bullets.bulletsManager;
import eem.bullets.firedBullet;
import eem.bullets.wave;
import eem.misc.logger;
import eem.misc.math;
import eem.motion.dangerMapMotion;
import eem.motion.dangerPath;
import eem.motion.dangerPathPoint;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedList;

public class safestPathMotion
extends dangerMapMotion {
    private dangerPath safestPath = new dangerPath();
    private dangerPathPoint DestinationDangerPathPoint = null;
    private dangerPathPoint seedDangerPathPoint = null;
    public LinkedList<dangerPath> dangerPaths;
    private double waveSafetyDist;
    private double guessFactorFlatenerStrength;
    private int NofGenNewPathAttempts;
    private int maxPathLength;
    private int pathSafetyMargin;

    @Override
    public void initTic() {
        this.seedDangerPathPoint = this.formCurDangerPointFromStatsNow();
        double d = this.myBot.myCoord.distance(this.DestinationDangerPathPoint.getPosition());
        if (d > 0.001) {
            logger.dbg("Go fix the code: to large deviation from expected position");
            logger.dbg("Deviation from predicted " + d);
            logger.dbg("Actual time " + this.myBot.getTime() + " expected " + this.DestinationDangerPathPoint.getTime());
            logger.dbg("Actual position " + this.myBot.myCoord);
            logger.dbg("Predicted position " + this.DestinationDangerPathPoint.getPosition());
            logger.dbg("Velocity expected " + this.DestinationDangerPathPoint.getVelocity() + " actual " + this.myBot.getVelocity());
            logger.dbg("Heading expected " + this.DestinationDangerPathPoint.getHeading() + " actual " + this.myBot.getHeading());
        }
        if (this.safestPath.size() < this.pathSafetyMargin) {
            this.safestPath = this.generateTheBestPath();
        }
        this.DestinationDangerPathPoint = this.safestPath.removeFirst();
    }

    public safestPathMotion(EvBot evBot) {
        super(evBot);
        this.waveSafetyDist = Math.sqrt(2.0) * (double)this.myBot.robotHalfSize + 1.0;
        this.guessFactorFlatenerStrength = 100.0;
        this.NofGenNewPathAttempts = 15000;
        this.maxPathLength = 50;
        this.pathSafetyMargin = 45;
        double d = 0.0;
        Point2D.Double double_ = (Point2D.Double)this.myBot.myCoord.clone();
        double d2 = this.myBot.getHeading();
        double d3 = this.myBot.getVelocity();
        this.seedDangerPathPoint = this.formCurDangerPointFromStatsNow();
        this.DestinationDangerPathPoint = new dangerPathPoint(double_, d, 0.0, 0.0, d3, d2, this.myBot.getTime());
        this.safestPath = this.generateTheBestPath();
    }

    public double possibleNewSpeed(double d) {
        double d2;
        double d3;
        double d4 = d;
        if (Math.abs(d) >= 8.0) {
            d3 = 0.0;
            d2 = 0.2;
        } else {
            d3 = 0.5;
            d2 = 0.2;
        }
        double d5 = Math.random();
        d4 = d5 <= d3 ? (double)math.signNoZero(d) * (Math.abs(d) + 1.0) : (d5 <= d3 + d2 ? (double)math.signNoZero(d) * (Math.abs(d) - 2.0) : d);
        if (Math.abs(d4) > 8.0) {
            d4 = math.signNoZero(d) * 8;
        }
        return d4;
    }

    public dangerPath generateTheBestPath() {
        double d = 1.0E9;
        dangerPath dangerPath2 = this.randomPath(this.safestPath, this.maxPathLength, d);
        d = dangerPath2.getDanger();
        for (int i = 0; i < this.NofGenNewPathAttempts; ++i) {
            dangerPath dangerPath3 = this.randomPath(d);
            if (!(dangerPath3.getDanger() < d)) continue;
            dangerPath2 = dangerPath3;
            d = dangerPath2.getDanger();
        }
        return dangerPath2;
    }

    double randomNewTurnAngle(double d) {
        double d2 = this.maxRotationPerTurnInDegrees(d);
        double d3 = Math.random();
        if (d3 <= 0.33) {
            return d2;
        }
        if (d3 <= 0.66) {
            return -d2;
        }
        return 0.0;
    }

    double randomNewHeading(double d, double d2) {
        d2 = math.shortest_arc(d2);
        double d3 = this.randomNewTurnAngle(d);
        return math.shortest_arc(d2 + d3);
    }

    public dangerPath randomPath() {
        return this.randomPath(1.0E9);
    }

    public double getNewVelocity(double d, double d2) {
        if (d < 0.0) {
            return -this.getNewVelocity(-d, -d2);
        }
        double d3 = 1.0;
        double d4 = 2.0;
        if (d == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (d != 0.0 && d2 == 0.0) {
            d2 = 1.0;
        }
        if (d2 > 0.0) {
            return Math.min(8.0, d + 1.0);
        }
        if (d > 2.0) {
            return d - 2.0;
        }
        double d5 = d - 2.0;
        return d5 / 2.0;
    }

    public double randomAccelDir(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (d == 0.0) {
            d2 = 0.333;
            d3 = 0.333;
        } else {
            d2 = 0.0;
            d3 = 0.8;
        }
        double d4 = Math.random();
        if (d4 < d2) {
            return 0.0;
        }
        if (d == 0.0) {
            return math.sign(Math.random() - 0.5);
        }
        if (d4 <= d2 + d3) {
            return math.sign(d);
        }
        return -math.sign(d);
    }

    public double pointDanger(dangerPathPoint dangerPathPoint2) {
        double d = 0.0;
        d += this.pointDangerFromWalls(dangerPathPoint2.getPosition(), 0.0);
        if (this.myBot.fightType().equals("1on1") || this.myBot.fightType().equals("melee1on1")) {
            d += this.pointDangerFromCorners(dangerPathPoint2.getPosition(), dangerPathPoint2.getVelocity());
        }
        d += this.pointDangerFromAllBots(dangerPathPoint2.getPosition());
        return d += this.pointDangerFromEnemyWavesAtTicTime(dangerPathPoint2.getPosition(), dangerPathPoint2.getTime());
    }

    public double pointDangerFromEnemyWavesAtTicTime(Point2D.Double double_, long l) {
        double d = 0.0;
        bulletsManager bulletsManager2 = this.myBot._bmanager;
        if (bulletsManager2 == null) {
            return 0.0;
        }
        LinkedList<wave> linkedList = bulletsManager2.getAllEnemyWaves();
        for (wave wave2 : linkedList) {
            double d2 = wave2.distance(double_, l);
            if (Math.abs(d2) > this.waveSafetyDist) continue;
            for (firedBullet firedBullet2 : wave2.getBullets()) {
                d += firedBullet2.pointDangerFromExactBulletHit(double_, l);
            }
            d += this.guessFactorFlatenerStrength * wave2.getGuessFactorNormProbForPoint(EvBot._tracker, double_);
        }
        return d;
    }

    public dangerPathPoint randomNewDangerPathPoint(dangerPathPoint dangerPathPoint2) {
        double d = 0.0;
        long l = dangerPathPoint2.getTime();
        double d2 = dangerPathPoint2.getHeading();
        double d3 = dangerPathPoint2.getVelocity();
        double d4 = this.randomAccelDir(d3);
        double d5 = this.randomNewTurnAngle(d3);
        double d6 = this.getNewVelocity(d3, d4);
        double d7 = d2 + d5;
        Point2D.Double double_ = (Point2D.Double)dangerPathPoint2.getPosition().clone();
        double_.x += d6 * Math.sin(d7 * Math.PI / 180.0);
        double_.y += d6 * Math.cos(d7 * Math.PI / 180.0);
        dangerPathPoint dangerPathPoint3 = new dangerPathPoint(double_, d, d5, d4, d6, d7, ++l);
        d = this.pointDanger(dangerPathPoint3);
        dangerPathPoint3.setDanger(d);
        return dangerPathPoint3;
    }

    public dangerPath randomPath(double d) {
        return this.randomPath(null, this.maxPathLength, d);
    }

    public dangerPathPoint formCurDangerPointFromStatsNow() {
        long l = this.myBot.getTime();
        double d = this.myBot.getHeading();
        double d2 = this.myBot.getVelocity();
        Point2D.Double double_ = (Point2D.Double)this.myBot.myCoord.clone();
        return new dangerPathPoint(double_, 0.0, 0.0, 0.0, d2, d, l);
    }

    public dangerPath recalculatePathDanger(dangerPath dangerPath2) {
        dangerPath dangerPath3 = new dangerPath();
        if (dangerPath2 == null) {
            return dangerPath3;
        }
        int n = dangerPath2.size();
        if (n == 0) {
            return dangerPath2;
        }
        for (int i = 0; i < n; ++i) {
            if (this.myBot.getTime() > this.DestinationDangerPathPoint.getTime()) continue;
            dangerPathPoint dangerPathPoint2 = dangerPath2.get(i);
            double d = this.pointDanger(dangerPathPoint2);
            dangerPathPoint2.setDanger(d);
            dangerPath3.add(dangerPathPoint2);
        }
        return dangerPath3;
    }

    public dangerPath randomPath(dangerPath dangerPath2, int n, double d) {
        dangerPathPoint dangerPathPoint2;
        int n2 = 0;
        if (dangerPath2 == null) {
            dangerPath2 = new dangerPath();
            n2 = 0;
            dangerPathPoint2 = this.seedDangerPathPoint;
        } else {
            n2 = dangerPath2.size();
            if (n2 > 0) {
                dangerPath2 = this.recalculatePathDanger(dangerPath2);
                dangerPathPoint2 = dangerPath2.get(n2 - 1);
            } else {
                dangerPathPoint2 = this.seedDangerPathPoint;
            }
        }
        while (n2 < n) {
            dangerPathPoint2 = this.randomNewDangerPathPoint(dangerPathPoint2);
            dangerPath2.add(dangerPathPoint2);
            ++n2;
            if (!(dangerPath2.getDanger() > d)) continue;
            return dangerPath2;
        }
        return dangerPath2;
    }

    private void buildListOfPathToTest() {
    }

    private void sortDangerPaths() {
        Collections.sort(this.dangerPaths);
    }

    @Override
    public void makeMove() {
        double d = 200.0 * this.DestinationDangerPathPoint.getAccelDir();
        double d2 = this.DestinationDangerPathPoint.getTurnAngle();
        this.myBot.setTurnRight(d2);
        this.myBot.setAhead(d);
    }

    @Override
    public void onPaint(Graphics2D graphics2D) {
        this.safestPath.onPaint(graphics2D);
    }
}

