/*
 * Decompiled with CFR 0.152.
 */
package eem.target;

import eem.EvBot;
import eem.misc.math;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class botStatPoint {
    private Point2D.Double pos = new Point2D.Double(0.0, 0.0);
    private long tStamp = 0L;
    private Point2D.Double velocity = new Point2D.Double(0.0, 0.0);
    private double headingDegrees = 0.0;
    private double energy = 0.0;
    private double dist2WallAhead = 0.0;

    public botStatPoint() {
    }

    public botStatPoint(AdvancedRobot advancedRobot, ScannedRobotEvent scannedRobotEvent) {
        this();
        Point2D.Double double_ = new Point2D.Double();
        double_.x = advancedRobot.getX();
        double_.y = advancedRobot.getY();
        double d = Math.toRadians(advancedRobot.getHeading() + scannedRobotEvent.getBearing());
        double d2 = scannedRobotEvent.getDistance();
        this.pos = new Point2D.Double(double_.x + Math.sin(d) * d2, double_.y + Math.cos(d) * d2);
        this.tStamp = advancedRobot.getTime();
        this.headingDegrees = scannedRobotEvent.getHeading();
        double d3 = scannedRobotEvent.getVelocity();
        this.velocity = new Point2D.Double(d3 * Math.sin(Math.toRadians(this.headingDegrees)), d3 * Math.cos(Math.toRadians(this.headingDegrees)));
        if (d3 < 0.0) {
            this.headingDegrees = math.shortest_arc(this.headingDegrees + 180.0);
        }
        this.energy = scannedRobotEvent.getEnergy();
        this.dist2WallAhead = this.distanceToWallAhead();
    }

    public botStatPoint(EvBot evBot) {
        this();
        this.pos.x = evBot.getX();
        this.pos.y = evBot.getY();
        this.tStamp = evBot.getTime();
        this.headingDegrees = evBot.getHeading();
        double d = evBot.getVelocity();
        this.velocity = new Point2D.Double(d * Math.sin(Math.toRadians(this.headingDegrees)), d * Math.cos(Math.toRadians(this.headingDegrees)));
        if (d < 0.0) {
            this.headingDegrees = math.shortest_arc(this.headingDegrees + 180.0);
        }
        this.energy = evBot.getEnergy();
        this.dist2WallAhead = this.distanceToWallAhead();
    }

    public botStatPoint(Point2D.Double double_, long l) {
        this();
        this.tStamp = l;
        this.pos = double_;
    }

    public Double getDistanceToWallAhead() {
        return this.dist2WallAhead;
    }

    public Double getDistance(Point2D.Double double_) {
        return double_.distance(this.pos);
    }

    public String format() {
        String string = "";
        string = string + "energy = " + this.energy + ", velocity = [ " + this.velocity.x + ", " + this.velocity.y + " ]" + ", heading = " + this.headingDegrees;
        string = string + "\n";
        string = string + "position = [ " + this.pos.x + ", " + this.pos.y + " ], tStamp = " + this.tStamp;
        string = string + "\n";
        string = string + "distance to " + this.whichWallAhead() + " wall ahead = " + this.getDistanceToWallAhead();
        return string;
    }

    public long getTime() {
        return this.tStamp;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getX() {
        return this.pos.x;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getHeadingDegrees() {
        return this.headingDegrees;
    }

    public double getHeadingRadians() {
        return Math.toRadians(this.headingDegrees);
    }

    public double getSpeed() {
        return this.velocity.distance(0.0, 0.0);
    }

    public Point2D.Double getVelocity() {
        return (Point2D.Double)this.velocity.clone();
    }

    public Point2D.Double getPosition() {
        return (Point2D.Double)this.pos.clone();
    }

    public boolean arePointsOfPathSimilar(botStatPoint botStatPoint2, botStatPoint botStatPoint3, botStatPoint botStatPoint4) {
        double d = 80.0;
        double d2 = 4.0;
        double d3 = 0.5;
        double d4 = 10.0;
        double d5 = this.getSpeed();
        double d6 = this.getHeadingDegrees() - botStatPoint4.getHeadingDegrees();
        long l = this.getTime() - botStatPoint4.getTime();
        double d7 = this.getDistanceToWallAhead();
        double d8 = botStatPoint3.getSpeed();
        double d9 = botStatPoint3.getHeadingDegrees() - botStatPoint2.getHeadingDegrees();
        long l2 = botStatPoint3.getTime() - botStatPoint2.getTime();
        double d10 = botStatPoint3.getDistanceToWallAhead();
        if (Math.abs(d5 - d8) > d3 || Math.abs(math.shortest_arc(d6 - d9)) > d4) {
            return false;
        }
        if (l != l2) {
            return false;
        }
        return !(Math.min(d10, d7) < d) || !(Math.abs(d7 - d10) > d2);
    }

    public String whichWallAhead(botStatPoint botStatPoint2) {
        return math.whichWallAhead(botStatPoint2.getPosition(), botStatPoint2.getSpeed(), botStatPoint2.getHeadingRadians());
    }

    public String whichWallAhead() {
        return this.whichWallAhead(this);
    }

    public double distanceToWallAhead(botStatPoint botStatPoint2) {
        return math.distanceToWallAhead(botStatPoint2.getPosition(), botStatPoint2.getSpeed(), botStatPoint2.getHeadingRadians());
    }

    public double distanceToWallAhead() {
        return this.distanceToWallAhead(this);
    }
}

