/*
 * Decompiled with CFR 0.152.
 */
package wiki.mako;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class MakoHT
extends AdvancedRobot {
    private static Point2D location = new Point2D.Double();
    private static Point2D oldLocation = new Point2D.Double();
    private static Point2D enemyLocation = new Point2D.Double();
    private static Point2D oldEnemyLocation = new Point2D.Double();
    private static Point2D impactLocation = new Point2D.Double();
    private static Rectangle2D fieldRectangle;
    private static boolean haveEnemy;
    private static double enemyDistance;
    private static double absoluteBearing;
    private static double deltaBearing;
    private static double meanAngularFactorLeft;
    private static double meanAngularFactorStraight;
    private static double meanAngularFactorRight;
    private static double meanOffsetFactorLeft;
    private static double meanOffsetFactorStraight;
    private static double meanOffsetFactorRight;
    private static double[] gunFactorLeft;
    private static double[] gunFactorStraight;
    private static double[] gunFactorRight;
    private static int wins;
    private static double[] gainedenergy;
    private static double[] lostenergy;
    private static double[] hisgainedenergy;
    private static double[] hislostenergy;
    private static double[] hits;
    private static double[] shots;
    private static double[] hishits;
    private static double[] hisshots;
    private double currentDirection = 1.0;
    private double currentEnergy = 100.0;
    private double currentVBound = 0.0;
    private long nextTime = 0L;

    public void run() {
        fieldRectangle = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.setColors(Color.gray, Color.gray, Color.yellow);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.addCustomEvent(new GunAimedCondition());
        double maxX = this.getBattleFieldWidth() - 18.0;
        double maxY = this.getBattleFieldHeight() - 18.0;
        if (gainedenergy == null) {
            double maxDistance = Point2D.distance(18.0, 18.0, maxX, maxY);
            gainedenergy = new double[(int)(maxDistance / 50.0) + 2];
            lostenergy = new double[(int)(maxDistance / 50.0) + 2];
            hisgainedenergy = new double[(int)(maxDistance / 50.0) + 2];
            hislostenergy = new double[(int)(maxDistance / 50.0) + 2];
            hits = new double[(int)(maxDistance / 50.0) + 2];
            shots = new double[(int)(maxDistance / 50.0) + 2];
            hishits = new double[(int)(maxDistance / 50.0) + 2];
            hisshots = new double[(int)(maxDistance / 50.0) + 2];
        }
        this.currentEnergy = 100.0;
        while (true) {
            this.setMaxVelocity(this.currentVBound);
            double futureX = this.currentDirection * this.currentVBound * 5.0 * Math.sin(this.getHeadingRadians()) + this.getX();
            double futureY = this.currentDirection * this.currentVBound * 5.0 * Math.cos(this.getHeadingRadians()) + this.getY();
            if (futureX < 18.0 || futureY < 18.0 || futureX > maxX || futureY > maxY) {
                this.currentDirection = -this.currentDirection;
            }
            this.setAhead(this.currentDirection * 40.0);
            if (!haveEnemy) {
                this.setTurnRadarLeft(22.5);
            }
            haveEnemy = false;
            this.execute();
        }
    }

    private final double normalize(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double rel;
        double d;
        oldLocation.setLocation(location);
        location.setLocation(this.getX(), this.getY());
        oldEnemyLocation.setLocation(enemyLocation);
        absoluteBearing = this.getHeading() + e.getBearing();
        enemyDistance = e.getDistance();
        this.toLocation(absoluteBearing, enemyDistance, location, enemyLocation);
        deltaBearing = MakoHT.rollingAvg(deltaBearing, this.absoluteBearing(oldLocation, enemyLocation) - this.absoluteBearing(oldLocation, oldEnemyLocation), 5.0, 1.0);
        haveEnemy = true;
        double radarTurn = MakoHT.normalRelativeAngle(this.getHeading() + e.getBearing() - this.getRadarHeading()) * 1.6;
        this.setTurnRadarRight(radarTurn);
        double denergy = this.currentEnergy - e.getEnergy();
        if (denergy >= 0.095 && denergy <= 3.0) {
            int n = (int)(e.getDistance() / 50.0);
            hislostenergy[n] = hislostenergy[n] + denergy;
            int n2 = (int)(e.getDistance() / 50.0);
            hisshots[n2] = hisshots[n2] + 1.0;
            if (this.getTime() >= this.nextTime) {
                double rand = Math.random() * 40.0 - 20.0;
                this.currentDirection = rand < 0.0 ? -1 : 1;
                this.currentVBound = Math.abs(rand);
                this.nextTime = this.getTime() + (long)((int)(e.getDistance() / (20.0 - 3.0 * denergy) / 2.0));
            }
        } else if (denergy != 0.0) {
            System.out.println(denergy);
        }
        this.currentEnergy -= denergy;
        double mindist = this.findDistanceBracket(200.0, 550.0);
        if (e.getDistance() < mindist + 100.0 && e.getDistance() > mindist - 50.0 && this.distanceFromCorner() > 200.0) {
            d = 1.5707963267948966;
        } else if ((e.getDistance() > mindist + 100.0 || this.distanceFromCorner() < 200.0) == this.currentDirection > 0.0) {
            d = 1.0471975511965976;
        } else {
            rel = 2.0943951023931953;
        }
        this.setTurnRightRadians(this.normalize(e.getBearingRadians() - rel));
        this.aimGun();
        if (this.currentEnergy == 0.0 && this.getOthers() == 1 && this.getTime() > this.nextTime) {
            this.goTo(enemyLocation);
        }
    }

    public void onCustomEvent(CustomEvent e) {
        Condition condition = e.getCondition();
        if (condition instanceof GunAimedCondition && this.currentEnergy > 0.0) {
            int n = (int)(enemyDistance / 50.0);
            shots[n] = shots[n] + 1.0;
            int n2 = (int)(enemyDistance / 50.0);
            lostenergy[n2] = lostenergy[n2] + this.bulletPower(this.currentEnergy);
            Bullet bullet = this.setFireBullet(this.bulletPower(this.currentEnergy));
            if (bullet != null) {
                this.addCustomEvent(new CheckVirtualGunsCondition(bullet));
            }
        }
    }

    public void onEnd() {
        System.out.println("dist | My gained | My lost | His gained | His lost | gained on him | hit rate | his hit rate");
        DecimalFormat fmt = new DecimalFormat("0.000");
        int i = 0;
        while (i < gainedenergy.length) {
            System.out.println(this.printFormatted(Integer.toString(i * 50), 4) + " | " + this.printFormatted(fmt.format(gainedenergy[i]), 9) + " | " + this.printFormatted(fmt.format(lostenergy[i]), 7) + " | " + this.printFormatted(fmt.format(hisgainedenergy[i]), 10) + " | " + this.printFormatted(fmt.format(hislostenergy[i]), 8) + " | " + this.printFormatted(fmt.format(this.findBenefit(i)), 13) + " | " + this.printFormatted(fmt.format(hits[i] / shots[i]), 8) + " | " + this.printFormatted(fmt.format(hishits[i] / hisshots[i]), 12));
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final String printFormatted(String string, int length) {
        block1: {
            if (string.length() <= length) ** GOTO lbl5
            string = string.substring(0, length - 1) + ".";
            break block1;
lbl-1000:
            // 1 sources

            {
                string = string + " ";
lbl5:
                // 2 sources

                ** while (string.length() < length)
            }
        }
        return string;
    }

    public void onWin(WinEvent e) {
        System.out.println("Wins: " + ++wins);
        this.onEnd();
    }

    public void onDeath(DeathEvent e) {
        System.out.println("Wins: " + wins);
        this.onEnd();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.currentEnergy += e.getPower() * 3.0;
        int n = (int)(enemyLocation.distance(this.getX(), this.getY()) / 50.0);
        hisgainedenergy[n] = hisgainedenergy[n] + e.getPower() * 3.0;
        double damage = Math.max(4.0 * e.getPower(), 4.0 * e.getPower() + 2.0 * (e.getPower() - 1.0));
        int n2 = (int)(enemyLocation.distance(this.getX(), this.getY()) / 50.0);
        lostenergy[n2] = lostenergy[n2] + damage;
        int n3 = (int)(enemyLocation.distance(this.getX(), this.getY()) / 50.0);
        hishits[n3] = hishits[n3] + 1.0;
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = Math.max(4.0 * power, 4.0 * power + 2.0 * (power - 1.0));
        int n = (int)(enemyLocation.distance(this.getX(), this.getY()) / 50.0);
        gainedenergy[n] = gainedenergy[n] + power * 3.0;
        int n2 = (int)(enemyLocation.distance(this.getX(), this.getY()) / 50.0);
        hislostenergy[n2] = hislostenergy[n2] + damage;
        int n3 = (int)(enemyLocation.distance(this.getX(), this.getY()) / 50.0);
        hits[n3] = hits[n3] + 1.0;
        this.currentEnergy -= damage;
    }

    public double findDistanceBracket(double min, double max) {
        int bestindex = (int)(min / 50.0 + 0.5);
        int i = (int)(min / 50.0 + 1.5);
        while (i <= (int)(max / 50.0 + 0.5)) {
            if (2.0 * this.findBenefit(i) + this.findBenefit(i + 1) + this.findBenefit(i - 1) > 2.0 * this.findBenefit(bestindex) + this.findBenefit(bestindex + 1) + this.findBenefit(bestindex - 1)) {
                bestindex = i;
            }
            ++i;
        }
        return bestindex * 50;
    }

    public double findBenefit(int index) {
        return (gainedenergy[index] - lostenergy[index] + hislostenergy[index] - hisgainedenergy[index]) / (gainedenergy[index] + lostenergy[index] + hislostenergy[index] + hisgainedenergy[index]);
    }

    private final double distanceFromCorner() {
        return Math.min(Math.min(Point2D.distance(this.getX(), this.getY(), 0.0, 0.0), Point2D.distance(this.getBattleFieldWidth(), this.getY(), this.getX(), 0.0)), Math.min(Point2D.distance(this.getX(), this.getBattleFieldHeight(), 0.0, this.getY()), Point2D.distance(this.getBattleFieldWidth(), this.getBattleFieldHeight(), this.getX(), this.getY())));
    }

    private final double bulletPower(double enemyEnergy) {
        double power = Math.min(enemyEnergy / 4.0, 3.0);
        power = Math.min(power, this.getEnergy() / 5.0);
        power = Math.min(power, 1200.0 / enemyDistance);
        return power;
    }

    private static final double guessedBearingAngular(double bearing, double delta, double diffFactor) {
        return bearing + delta * diffFactor;
    }

    private static final double guessedBearingOffset(double bearing, double offsetFactor) {
        return bearing + offsetFactor;
    }

    private final void aimGun() {
        double guessedBearing;
        double absoluteBearing = this.absoluteBearing(location, enemyLocation);
        double guessedDistance = location.distance(enemyLocation);
        double meanAngularFactor = meanAngularFactorStraight;
        double meanOffsetFactor = meanOffsetFactorStraight;
        double[] gunFactor = gunFactorStraight;
        if (deltaBearing < -0.3) {
            meanAngularFactor = meanAngularFactorLeft;
            meanOffsetFactor = meanOffsetFactorLeft;
            gunFactor = gunFactorLeft;
        } else if (deltaBearing > 0.3) {
            meanAngularFactor = meanAngularFactorRight;
            meanOffsetFactor = meanOffsetFactorRight;
            gunFactor = gunFactorRight;
        }
        if (gunFactor[0] < gunFactor[1]) {
            double d = MakoHT.guessedBearingAngular(absoluteBearing, deltaBearing, meanAngularFactor);
        } else {
            guessedBearing = MakoHT.guessedBearingOffset(absoluteBearing, meanOffsetFactor);
        }
        this.toLocation(guessedBearing, guessedDistance, location, impactLocation);
        this.translateInsideField(impactLocation, 1.0);
        guessedBearing = this.absoluteBearing(location, impactLocation);
        this.setTurnGunRight(MakoHT.normalRelativeAngle(guessedBearing - this.getGunHeading()));
    }

    private final void goTo(Point2D point) {
        double distance = location.distance(point);
        double angle = MakoHT.normalRelativeAngle(this.absoluteBearing(location, point) - this.getHeading());
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= 180.0) : (angle += 180.0);
        }
        this.setTurnRight(angle);
        this.setAhead(distance);
    }

    private static final double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    private static final long travelTime(double distance, double velocity) {
        return (int)Math.round(distance / velocity);
    }

    private final void translateInsideField(Point2D point, double margin) {
        point.setLocation(Math.max(margin, Math.min(fieldRectangle.getWidth() - margin, point.getX())), Math.max(margin, Math.min(fieldRectangle.getHeight() - margin, point.getY())));
    }

    private final void toLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(Math.toRadians(angle)) * length, sourceLocation.getY() + Math.cos(Math.toRadians(angle)) * length);
    }

    private final double absoluteBearing(Point2D source, Point2D target) {
        return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }

    private static final double normalRelativeAngle(double angle) {
        double relativeAngle = angle % 360.0;
        if (relativeAngle <= -180.0) {
            return 180.0 + relativeAngle % 180.0;
        }
        if (relativeAngle > 180.0) {
            return -180.0 + relativeAngle % 180.0;
        }
        return relativeAngle;
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    static {
        meanAngularFactorLeft = 9.0;
        meanAngularFactorStraight = 1.0;
        meanAngularFactorRight = 9.0;
        meanOffsetFactorLeft = 0.0;
        meanOffsetFactorStraight = 0.0;
        meanOffsetFactorRight = 0.0;
        gunFactorLeft = new double[2];
        gunFactorStraight = new double[2];
        gunFactorRight = new double[2];
    }

    class CheckVirtualGunsCondition
    extends Condition {
        private long time;
        private double bulletVelocity;
        private double bulletPower;
        private double bearingDelta;
        private Point2D oldRLocation = new Point2D.Double();
        private Point2D oldELocation = new Point2D.Double();
        private double oldBearing;

        public boolean test() {
            if (MakoHT.this.getOthers() == 0) {
                return false;
            }
            double bulletDistance = this.bulletVelocity * (double)(MakoHT.this.getTime() - this.time);
            if (bulletDistance > location.distance(enemyLocation) - 10.0) {
                if (this.bearingDelta > 0.05) {
                    double impactBearing = MakoHT.this.absoluteBearing(this.oldRLocation, enemyLocation);
                    double bearingDiff = MakoHT.normalRelativeAngle(impactBearing - this.oldBearing);
                    double factor = bearingDiff / this.bearingDelta;
                    if (this.bearingDelta < -0.3) {
                        meanAngularFactorLeft = MakoHT.rollingAvg(meanAngularFactorLeft, factor, 50.0, this.bulletPower);
                        meanOffsetFactorLeft = MakoHT.rollingAvg(meanOffsetFactorLeft, bearingDiff, 50.0, this.bulletPower);
                        double miss = Math.abs(MakoHT.normalRelativeAngle(impactBearing - MakoHT.guessedBearingAngular(this.oldBearing, this.bearingDelta, meanAngularFactorLeft)));
                        gunFactorLeft[0] = MakoHT.rollingAvg(gunFactorLeft[0], miss, 50.0, this.bulletPower);
                        miss = Math.abs(MakoHT.normalRelativeAngle(impactBearing - MakoHT.guessedBearingOffset(this.oldBearing, meanOffsetFactorLeft)));
                        gunFactorLeft[1] = MakoHT.rollingAvg(gunFactorLeft[1], miss, 50.0, this.bulletPower);
                    } else if (this.bearingDelta > 0.3) {
                        meanAngularFactorRight = MakoHT.rollingAvg(meanAngularFactorRight, factor, 50.0, this.bulletPower);
                        meanOffsetFactorRight = MakoHT.rollingAvg(meanOffsetFactorRight, bearingDiff, 50.0, this.bulletPower);
                        double miss = Math.abs(MakoHT.normalRelativeAngle(impactBearing - MakoHT.guessedBearingAngular(this.oldBearing, this.bearingDelta, meanAngularFactorRight)));
                        gunFactorRight[0] = MakoHT.rollingAvg(gunFactorRight[0], miss, 50.0, this.bulletPower);
                        miss = Math.abs(MakoHT.normalRelativeAngle(impactBearing - MakoHT.guessedBearingOffset(this.oldBearing, meanOffsetFactorRight)));
                        gunFactorRight[1] = MakoHT.rollingAvg(gunFactorRight[1], miss, 50.0, this.bulletPower);
                    } else {
                        meanAngularFactorStraight = MakoHT.rollingAvg(meanAngularFactorStraight, factor, 50.0, this.bulletPower);
                        meanOffsetFactorStraight = MakoHT.rollingAvg(meanOffsetFactorStraight, bearingDiff, 50.0, this.bulletPower);
                        double miss = Math.abs(MakoHT.normalRelativeAngle(impactBearing - MakoHT.guessedBearingAngular(this.oldBearing, this.bearingDelta, meanAngularFactorStraight)));
                        gunFactorStraight[0] = MakoHT.rollingAvg(gunFactorStraight[0], miss, 50.0, this.bulletPower);
                        miss = Math.abs(MakoHT.normalRelativeAngle(impactBearing - MakoHT.guessedBearingOffset(this.oldBearing, meanOffsetFactorStraight)));
                        gunFactorStraight[1] = MakoHT.rollingAvg(gunFactorStraight[1], miss, 50.0, this.bulletPower);
                    }
                }
                MakoHT.this.removeCustomEvent(this);
            }
            return false;
        }

        public CheckVirtualGunsCondition(Bullet bullet) {
            this.time = MakoHT.this.getTime();
            this.bulletVelocity = bullet.getVelocity();
            this.bulletPower = bullet.getPower();
            this.bearingDelta = deltaBearing;
            this.oldRLocation.setLocation(location);
            this.oldELocation.setLocation(enemyLocation);
            this.oldBearing = MakoHT.this.absoluteBearing(this.oldRLocation, this.oldELocation);
        }
    }

    class GunAimedCondition
    extends Condition {
        public boolean test() {
            if (MakoHT.this.getOthers() == 0) {
                MakoHT.this.removeCustomEvent(this);
            }
            return MakoHT.this.getGunHeat() == 0.0 && MakoHT.this.getGunTurnRemaining() == 0.0;
        }

        GunAimedCondition() {
        }
    }
}

