/*
 * Decompiled with CFR 0.152.
 */
package synnalagma.shooting;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import synnalagma.BulletTracker;
import synnalagma.Ennemi;
import synnalagma.RobotBase;
import synnalagma.shooting.DiscAvecHist;
import synnalagma.shooting.ShootTactique;

public class ShootManager {
    private Ennemi target;
    public ShootTactique[] strategies;
    private ShootTactique current;
    private int size;

    public ShootManager(Ennemi ennemi) {
        this.target = ennemi;
        this.size = 1;
        this.strategies = new ShootTactique[this.size];
        this.strategies[0] = new DiscAvecHist(ennemi);
        this.current = this.strategies[0];
    }

    public ShootTactique getCurrent() {
        return this.current;
    }

    public boolean chooseBest() {
        this.current = this.strategies[0];
        return true;
    }

    public void shoot() {
        double d;
        if (this.chooseBest() && RobotBase.monRobot.getGunHeat() == 0.0 && this.current.aim(d = this.getFirePower())) {
            this.current.shoot(d);
        }
    }

    public String toString() {
        String string = "\n";
        int n = 0;
        while (n < this.strategies.length) {
            string = string + this.strategies[n].toString() + "\n\n";
            ++n;
        }
        return string;
    }

    public void update(BulletTracker bulletTracker) {
        bulletTracker.tact.update(bulletTracker);
    }

    public void save(DataOutputStream dataOutputStream) {
        int n = 0;
        while (n < this.size) {
            this.strategies[n].save(dataOutputStream);
            ++n;
        }
    }

    public void load(DataInputStream dataInputStream) {
        int n = 0;
        while (n < this.size) {
            this.strategies[n].load(dataInputStream);
            ++n;
        }
    }

    public double getFirePower() {
        double d = Math.min(RobotBase.monRobot.getEnergy() / 7.0, 800.0 / RobotBase.monRobot.distanceTo(this.target));
        if (d > 3.0) {
            d = 3.0;
        }
        return d;
    }
}

