/*
 * Decompiled with CFR 0.152.
 */
package synnalagma.shooting;

import synnalagma.Ennemi;
import synnalagma.Point;
import synnalagma.shooting.ShootTactique;

public class VirtualBullet {
    public static final int MISSED = 0;
    public static final int HIT = 1;
    public static final int UNKNOW = 2;
    public Point currentPos;
    public double speed;
    public double baseX;
    public double baseY;
    public double heading;
    public int state = 2;
    public ShootTactique tact;
    public int[] additionnalInfo;
    public double[] doubleInfo;
    public Ennemi cible;
    public long timeOfShoot = 0L;

    public VirtualBullet(double d, double d2, double d3, double d4, ShootTactique shootTactique, int[] nArray, Ennemi ennemi) {
        this.currentPos = new Point(d, d2, d3);
        this.baseX = d;
        this.baseY = d2;
        this.heading = d4;
        this.tact = shootTactique;
        this.additionnalInfo = nArray;
        this.cible = ennemi;
        this.speed = 20.0 - 3.0 * d3;
    }

    public VirtualBullet(double d, double d2, double d3, double d4, ShootTactique shootTactique, int[] nArray, Ennemi ennemi, double[] dArray, long l) {
        this.currentPos = new Point(d, d2, d3);
        this.baseX = d;
        this.baseY = d2;
        this.heading = d4;
        this.tact = shootTactique;
        this.additionnalInfo = nArray;
        this.cible = ennemi;
        this.speed = 20.0 - 3.0 * d3;
        this.doubleInfo = dArray;
        this.timeOfShoot = l;
    }

    public int update(double d) {
        double d2 = this.currentPos.x;
        double d3 = this.currentPos.y;
        this.currentPos.nextCircular(this.speed, this.heading, 0.0, d);
        if (!this.currentPos.isValid()) {
            return 0;
        }
        if (this.currentPos.distance(this.baseX, this.baseY) > this.cible.distance(this.baseX, this.baseY) + 30.0) {
            this.state = 0;
            return 0;
        }
        if (this.cible.getBox().intersectsLine(d2, d3, this.currentPos.x, this.currentPos.y)) {
            this.state = 1;
            return 1;
        }
        return 2;
    }
}

