package dft.bin;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import robocode.*;

public class State {

	private AdvancedRobot robot;
	
	public Rectangle2D battleField;
	
	private double absBearing;
	private double oppAbsBearing;
	
	private double lastBulletPower=1.9;
	private long lastBulletFireTime;
	
	private double enemyBearing;
	private double enemyHeading;
	private double enemyVelocity;
	private double enemyLastVelocity;
	private double enemyDistance;
	private double enemyLateralVelocity;
	private double enemyDirection=1;
	private double enemyEnergy;
	private double enemyGunHeat=3.0;
	
	private long enemyTimeSinceVelocityChange;
	
	private Point2D enemyLocation;
	private Point2D robotLocation;
	
	private double enemyClosestWall;
	private double robotClosestWall;
	
	private double robotLateralVelocity;
	private double robotVelocity;
	private double robotDirection=1;
		
	private long time;
	
	public State(AdvancedRobot a) {
		time = -1;
		robot = a;
		battleField = new Rectangle2D.Double(18,18,a.getBattleFieldWidth()-36,a.getBattleFieldHeight()-36);
		robotLocation = new Point2D.Double(0,0);		
	}
		
	public void onRobotDeath(RobotDeathEvent e) {
		
	}
	
	public void onBulletHit(BulletHitEvent e) {
		Bullet b = e.getBullet();
        double power = b.getPower();
        enemyEnergy -= 4*power + Math.max(2*power - 1, 0);
	}
	
	public void updateGunHeat(double power) {
		enemyGunHeat = 1 + power/5.0;
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {	
		while (robot.getTime()>time) {
			enemyGunHeat -= robot.getGunCoolingRate();
			time++;
		}
		absBearing = robot.getHeadingRadians()+e.getBearingRadians();
		enemyBearing = e.getBearingRadians();
		enemyHeading = e.getHeadingRadians();
		if (enemyLastVelocity!=e.getVelocity())
			enemyTimeSinceVelocityChange=0;
		else
			enemyTimeSinceVelocityChange++;
		enemyVelocity = e.getVelocity();
		enemyDistance = e.getDistance();
		enemyEnergy = e.getEnergy();
		enemyLateralVelocity = enemyVelocity*Math.sin(enemyHeading-absBearing);
		if (enemyLateralVelocity!=0)
			enemyDirection = enemyLateralVelocity>0?1:-1;
		robotLocation = new Point2D.Double(robot.getX(), robot.getY());		
		enemyLocation = Utils.project(robotLocation,absBearing,enemyDistance);
		oppAbsBearing = Utils.absoluteBearing(enemyLocation,robotLocation);
		robotVelocity = robot.getVelocity();
		robotLateralVelocity = robot.getVelocity()*Math.sin(robot.getHeadingRadians()-oppAbsBearing);
		if (robotLateralVelocity!=0)
			robotDirection = robotLateralVelocity>0?1:-1;
		
	}
	
	public double getRobotVelocity() {
		return robotVelocity;
	}
	
	public double getEnemyGunHeat() {
		return enemyGunHeat;
	}
	
	public double getEnemyClosestWall() {
		return Utils.getClosestWall(battleField, enemyLocation.getX(),enemyLocation.getY());
	}
	
	public double getRobotClosestWall() {
		return Utils.getClosestWall(battleField, robotLocation.getX(),robotLocation.getY());
		
	}	
	public Point2D getEnemyMirrorPosition() {
		Point2D pos = new Point2D.Double(
				battleField.getWidth()-getEnemyLocation().getX(),
				battleField.getHeight()-getEnemyLocation().getY());
		double wall = getEnemyClosestWall();
		if (wall==0)
			pos.setLocation(pos.getX(),100);
		else if (wall==180)
			pos.setLocation(pos.getX(),battleField.getHeight()-100);
		else if (wall==90)
			pos.setLocation(100,pos.getY());
		else if (wall==270)
			pos.setLocation(battleField.getWidth()-100,pos.getY());
		return pos;
	}
	
	public AdvancedRobot getRobot() {
		return robot;
	}
	
	public double getAbsBearing() {
		return absBearing;	
	}
		
	public double getOppAbsBearing() {
		return oppAbsBearing;	
	}
	
	public double getEnemyBearing() {
		return enemyBearing;
	}
	
	public double getEnemyHeading() {
		return enemyHeading;
	}
	
	public double getEnemyVelocity() {
		return enemyVelocity;
	}
	
	public double getEnemyDirection() {
		return enemyDirection;
	}
	
	public double getEnemyDistance() {
		return enemyDistance;
	}
	
	public double getEnemyEnergy() {
		return enemyEnergy;
	}
	
	public long getEnemyTimeSinceVelocityChange() {
		return enemyTimeSinceVelocityChange;
	}
	
	public double getEnemyLateralVelocity() {
		return enemyLateralVelocity;
	}
	
	public Point2D getEnemyLocation() {
		return enemyLocation;
	}
			
	public Point2D getRobotLocation() {
		return robotLocation;
	}
	
	public double getRobotDirection() {
		return robotDirection;
	}
	
	public double getRobotLateralVelocity() {
		return robotLateralVelocity;
	}
	
	public long getTime() {
		return time;
	}
	
	public void setLastBulletPower(double power) {
		lastBulletPower = power;
	}
	
	public double getLastBulletPower() {
		return lastBulletPower;
	}
	
	public long getLastBulletFireTime() {
		return lastBulletFireTime;
	}
	public void setLastBulletFireTime(long time) {
		lastBulletFireTime = time;
	}
		
}
