package nz.jdc.nano;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 * NeophytePattern
 * My third bot. Sibling to NeophytePRAL and NeophyteSRAL.
 * 
 * I can't really claim much credit for this bot. The gun is a near copy of
 * that in WeekendObsession. Most of the nano pattern guns perform similarly,
 * but WeekendObsession was the smallest. I compromised and made it fractionally
 * smaller still. 
 * As per its siblings, the movement is based on Freddie.
 * 
 * Firing: Pattern matching.
 * Movement: Bullet dodge. Toggles between uni-directional and reversing moves.
 * 
 * Credits: 
 * Gun is a slightly modified copy of Eric Simonton's WeekendObsession.
 * Movement is based on the very elegant movement strategy of dft.Freddie 1.32 by Alcatraz271.
 *  
 * Version 1.0: Should be pretty good even though it is the first version as both the gun and the
 *   movement are well established.
 *   Codesize 246.
 * 
 * Version 1.1: Some minor tweaks to movement and fire power.
 *   Codesize 249.
 *
 * @author John Cleland 
 */
public class NeophytePattern extends AdvancedRobot {
  // tunable constants
  // for movement
  private final static double MOVE_DISTANCE       = 200;
  private final static double NON_RAND            = 0.16;
  private final static double PREFERRED_RANGE     = 200;
  private final static double CLOSE_FCT           = 477 * MOVE_DISTANCE;
  
  // for gun
  private final static int    BULLET_POWER        = 2; 
  private final static double BULLET_SPEED        = 20.0 - 3.0 * (double) BULLET_POWER; 
  private final static double DISTANCE_DIVISOR    = PREFERRED_RANGE;
  private final static int    PREDICT_TICKS       = (int) (DISTANCE_DIVISOR / BULLET_SPEED + 1.5);
  private final static int    MAX_MATCH_LEN       = 57;
  
  // attributes
  // for movement
  private static double       enemyEnergy;
  private static double       moveDir             = MOVE_DISTANCE;
  private static int          moveMode            = 1;

  /**
   * Bot run method.
   */
  public void run() {
    // start our infinite radar loop
    turnRadarRightRadians(Double.POSITIVE_INFINITY);
  }
  
  /**
   * Scan handler.
   * This is where it all happens.
   */ 
  public void onScannedRobot(ScannedRobotEvent e) {
    // register vars, should be the most commonly used
    int    ri = MAX_MATCH_LEN;
    double rd = e.getBearingRadians();
 
    // other vars
    int matchPos;
     
    // radar scan
    setTurnRadarLeftRadians(getRadarTurnRemaining());
    
    // bullet dodge a random distance
    if (enemyEnergy > (enemyEnergy = e.getEnergy())) {
      setAhead((moveDir *= moveMode) * (Math.random() + NON_RAND));
    }
    
    // turn perpendicular with range control
    setTurnRightRadians(Math.cos(rd - (e.getDistance() - PREFERRED_RANGE) * moveDir / CLOSE_FCT));
    
    // rd has enemy relative bearing, now updated to absolute bearing
    rd += getHeadingRadians();

    // pattern gun from WeekendOnsession by Eric Simonton
    // add last enemy move to the pattern
    enemyHistory = String.valueOf((char) (e.getVelocity() * (Math.sin(e.getHeadingRadians() - rd)))).concat(enemyHistory);
    
    // search for a match
    while((matchPos = enemyHistory.indexOf(enemyHistory.substring(0, ri-=2), PREDICT_TICKS)) < 0);
    
    // calculate aim offset
    ri = PREDICT_TICKS;
    do { rd += ((short) enemyHistory.charAt(--matchPos)) / DISTANCE_DIVISOR; } while (--ri > 0);
    
    // turn gun
    setTurnGunRightRadians(Utils.normalRelativeAngle(rd - getGunHeadingRadians()));
    
    // fire
    setFire(BULLET_POWER + 125 / (int) e.getDistance());  
  }
  
  /**
   * Hit a wall, reverse direction and start moving immediately.
   */
  public void onHitWall(HitWallEvent e) {
    setAhead(moveDir = -moveDir);
  }

  /**
   * Hit by bullet, change movement strategy.
   */
  public void onHitByBullet(HitByBulletEvent e) {
    moveMode = -moveMode;
  }

  // the pattern
  public static String enemyHistory = ""
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 1
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 2
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char)-1
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char)-2 + (char)-4 + (char)-6
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-7 + (char)-6 + (char)-5 + (char)-4
    + (char)-3 + (char)-2 + (char)-1 + (char) 0
    + (char) 2 + (char) 4 + (char) 6 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 7 + (char) 6 + (char) 5 + (char) 4
    + (char) 3 + (char) 2 + (char) 1 + (char) 0;

}
