package ags.muse.recon;

import ags.muse.base.Rules;
import ags.muse.recon.events.*;

public class EnemyRobot extends Robot{
    private double pendingExpectedHealthChange;
    private double expectedHealthChange;
    public double getExpectedHealthChange() { return expectedHealthChange; }

    public EnemyRobot(Rules rules, SelfRobot self, String name) {
        super(rules, self, name);
        pendingExpectedHealthChange = 0;
        expectedHealthChange = 0;
    }
    
    @Override
    public boolean update(ReconEvent event) {
        if (!(event instanceof ScanReconEvent)) {
            throw new IllegalArgumentException();
        }
        expectedHealthChange = pendingExpectedHealthChange;
        pendingExpectedHealthChange = 0;
        return super.update(event);
    }

    public void recordPendingExpectedHealthChange(double d) {
        pendingExpectedHealthChange += d;
    }
}
