package djc.util;

import djc.*;
import djc.util.*;

import java.awt.*;
import java.awt.geom.*;     // for Point2D's

import robocode.*;
import robocode.util.*;

/**
 * MyUtils
 */
public class MyUtils
{
	public static double maxMin(double maxval, double minval, double  value) {		//value returned is limited to the the max and min specified values 
		return Math.min(maxval, Math.max(minval, value));
	}

    public static double minMax(double v, double min, double max) {
		return Math.max(min, Math.min(max, v));
    }

	public static int sign(double v) {
		return (v > 0) ? 1 : -1;
	}

	public static int sign(int v) {
		return (v > 0) ? 1 : -1;
	}

    /**
     * Based on RoboCode FAQ.
     *
     * @see <a href="http://robocode.alphaworks.ibm.com/help/robocode.faq.txt">FAQ</a>
     * Author Dan Cieslak
     */
    public static double getPowerToKill(double energy) {
		if(energy < 4.0) 
	    	return Math.max(DynaBotConstants.MIN_SHOT_ENERGY, (energy / 4.0));
		else {
		    return Math.min(DynaBotConstants.MAX_SHOT_ENERGY, ((energy - 2.0) / 6.0));
		}
    }

	public static int getDistanceBin(double dist) {
		if(dist < DynaBotConstants.DIST_CLOSE) return DynaBotConstants.DIST_SEG_CLOSE;
		else if(dist < DynaBotConstants.DIST_NEAR) return DynaBotConstants.DIST_SEG_NEAR;
		else if(dist < DynaBotConstants.DIST_MID) return DynaBotConstants.DIST_SEG_MID;
		else if(dist < DynaBotConstants.DIST_LONG) return DynaBotConstants.DIST_SEG_LONG;
		else return DynaBotConstants.DIST_SEG_XTRM;
	}

	public static int getGameStage(int numOthers) {
		if(numOthers == 1) return  DynaBotConstants.GAMESTAGE_DUEL;
		else if(numOthers <= 4) return DynaBotConstants.GAMESTAGE_THREEORFOUR;
		else return DynaBotConstants.GAMESTAGE_FIVEPLUS;
	}

    /**
     * Based on RoboCode FAQ.
     *
     * @see <a href="http://robocode.alphaworks.ibm.com/help/robocode.faq.txt">FAQ</a>
     * Author Dan Cieslak
     */
    public static double getBulletDamage(double power) {
		double retval = 4.0 * power;
		if(power > 1.0) retval += 2.0 * (power - 1.0);
		return retval;
    }

    /**
     * Based on RoboCode FAQ.
     *
     * @see <a href="http://robocode.alphaworks.ibm.com/help/robocode.faq.txt">FAQ</a>
     */
    public static double getShotEnergyLoss(double power) {
		return power;
    }

    /**
     * Based on RoboCode FAQ.
     *
     * @see <a href="http://robocode.alphaworks.ibm.com/help/robocode.faq.txt">FAQ</a>
     */
   	public static double getShotVelocity(double power) {
		return 20.0 - 3.0 * power;
    }

    /**
     * Based on RoboCode FAQ.
     *
     * @see <a href="http://robocode.alphaworks.ibm.com/help/robocode.faq.txt">FAQ</a>
     */
    public static double getShotEnergyGain(double power) {
		return 3.0 * power;
    }

    /**
     * Based on RoboCode FAQ.
     *
     * @see <a href="http://robocode.alphaworks.ibm.com/help/robocode.faq.txt">FAQ</a>
     */
    public static double getShotPowerFromEnergyGain(double energy) {
		return energy / 3.0;
    }

    /**
     * Based on RoboCode FAQ.
     *
     * @see <a href="http://robocode.alphaworks.ibm.com/help/robocode.faq.txt">FAQ</a>
     */
    public static double getTurningRate(double velocity)
    {
		return 10.0 - .75 * velocity;
    }

    // CREDIT: from CassiusClay, by PEZ
    //   - returns point length away from sourceLocation, at angle
    // robowiki.net?CassiusClay
    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }

    // got this from RaikoMicro, by Jamougha, but I think it's used by many authors
    //  - returns the absolute angle (in radians) from source to target points
    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

	public static double absBearing( double x1,double y1, double x2,double y2 ) {		//returns the bearing of point 2 from point 1 (+/- PI/2)
		return Math.atan2(x2-x1,y2-y1);
	}

	public static double getRange( double x1,double y1, double x2,double y2 ) {		//returns the distance between two points
		double xo = x2-x1;
		double yo = y2-y1;
		return Math.sqrt( ( (xo)*(xo) ) + ( (yo)*(yo) ) );
	}


    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(50);
        } else {
            if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           } else {
                robot.setTurnRightRadians(angle);
           }
            robot.setAhead(50);
        }
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle, Graphics2D g, Color c) {
        double angle = Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            Point2D.Double p = project(new Point2D.Double(robot.getX(), robot.getY()), angle, -75);
			g.setColor(c);
			g.fillOval((int)p.getX(), (int)p.getY(), 15, 15);
        } else {
            if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           } else {
                robot.setTurnRightRadians(angle);
           }
            Point2D.Double p = project(new Point2D.Double(robot.getX(), robot.getY()), angle, 75);
			g.setColor(c);
			g.fillOval((int)p.getX(), (int)p.getY(), 15, 15);
        }
    }

	public static int getVelocityIndex(double velocity) {
		return (int)Math.abs(velocity / 2.0);
	}

    public static int getBeeGunVelocityIndex(double velocity) {
		velocity = Math.abs(velocity);
		if (velocity > 7.5) {
		    return 4;
		}
		if (velocity > 5.0) {
		    return 3;
		}
		if (velocity > 2.5) {
	    	return 2;
		}
		if (velocity > 0.0) {
	    	return 1;
		}
		return 0;
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting ) {
		return (value*n + newEntry*weighting)/(n + weighting);
    } 


}
