/*
 * Created on 2004-9-30
 */
package tide;

/**
 * this event occurred when another robot death.
 * 
 * @author xiemin
 */
public class RobotDeathEvent extends Event
{
	//the name of the died robot
	private String name;
	
	/**
	 * create a new RobotDeathEvent.
	 * @param event robocode RobotDeathEvent
	 */
	public RobotDeathEvent( robocode.RobotDeathEvent event)
	{
		super(event);
		this.name = event.getName();
	}
	
	/**
	 * Return the name of the died robot
	 * @return the name of the died robot
	 */
	public String getName()
	{
		return name;
	}
	
}

