package kc.micro;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;

/**
 * Thorn - a robot by Kevin Clark (Kev).
 * See http://robowiki.net/wiki/Thorn for more information. 
 *
 * Code is released under the RoboWiki Public Code Licence (see http://robowiki.net/wiki/RWPCL)
 */
public class Thorn extends AdvancedRobot {
	static final int AIM_FACTORS = 62;
	static final int MIDDLE_FACTOR = AIM_FACTORS / 2;
	static final double ESCAPE_ANGLE = 1.2164911578 / MIDDLE_FACTOR;
	
	static Point2D.Double enemyLocation;
	static double enemyEnergy;
	static double enemyBulletSpeed; 
	static double enemyVelocity;
	static double enemyOrbitDirection;
	
	static int direction = 1;
	static int movementMode;
	
	static int[][][][][][] data = new int[5][3][5][3][2][AIM_FACTORS];
	
	public void run() {
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		
		do {
			turnRadarLeftRadians(1);
		} while(true);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {			
		Wave w = new Wave();
		
		double temp = e.getDistance();//used for distance, target heading, and energy difference
		int temp2 = (int)(Math.min(temp / 100, 1));//used for anti-ram mode and current guessfactor
		
		double absoluteBearing;
		enemyLocation = projectMotion(absoluteBearing = w.absoluteBearing = e.getBearingRadians() + getHeadingRadians(), temp);
		w.source = new Point2D.Double(getX(), getY());
		
		w.guessFactors = data[(int)(temp / 200)]
		                     [1 + (int)Math.signum(enemyVelocity - (enemyVelocity = Math.abs(e.getVelocity())))]
		                     [(int)(enemyVelocity) >> 1]
		                     [fieldContains(absoluteBearing + ((0.25 / ESCAPE_ANGLE) * (w.orbitDirection = enemyOrbitDirection = (enemyVelocity == 0 ? enemyOrbitDirection : Math.signum(Math.sin(e.getHeadingRadians() - absoluteBearing) * e.getVelocity()) * ESCAPE_ANGLE))), temp) ? (fieldContains(absoluteBearing + ((0.55 / ESCAPE_ANGLE)  * enemyOrbitDirection), temp) ? 2 : 1) : 0]
							 [fieldContains(absoluteBearing - ((0.55 / ESCAPE_ANGLE)  * enemyOrbitDirection), temp) ? 1 : 0];		 
							
		double targetHeading;
        double offset = Math.PI/2 + 1 - (temp / 530);
	    while(!fieldContains(targetHeading = absoluteBearing + (direction * (offset -= 0.01)), 170));
		if((Math.random() < movementMode * temp2 * 0.70 * Math.pow(temp / enemyBulletSpeed, -0.65)) || offset < Math.PI/3.5) {
			direction = -direction;
		}
		setTurnRightRadians(Math.tan(targetHeading -= getHeadingRadians()));
    
		if((temp = enemyEnergy - (enemyEnergy = e.getEnergy())) - temp2 + movementMode > -1 && temp <= 3.0) {
		    setAhead(((3 + (int)(temp / 0.5000001)) << 3) * Math.signum(Math.cos(targetHeading)));
		}
		
		if((int)(getEnergy()) > 3) {
			if(setFireBullet(3 - temp2) != null) {
				w.weight = 3;
			}
			addCustomEvent(w);
		}
		
		int bestGF = MIDDLE_FACTOR;
		try {
			while(true) {
				if(w.guessFactors[temp2] > w.guessFactors[bestGF]) {
					bestGF = temp2;
				}
				temp2++;
			}
		} catch(Exception ex) {}
		
		setTurnGunRightRadians(0.0005 + Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + ((bestGF - MIDDLE_FACTOR) * enemyOrbitDirection)));
		setTurnRadarRightRadians(2 * Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
	}
	
	public void onBulletHit(BulletHitEvent e) {
		enemyEnergy -= 10;
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		enemyEnergy += 20 - (enemyBulletSpeed = e.getVelocity());	
    }

	public void onDeath(DeathEvent e) {
		if(getRoundNum() < 4) {
			movementMode = 1;
		}
	}

	boolean fieldContains(double heading, double distance) {
		return new Rectangle2D.Double(18, 18, 764, 564).contains(projectMotion(heading, distance));
	}
	
	Point2D.Double projectMotion(double heading, double distance) {	
		return new Point2D.Double(getX() + (distance * Math.sin(heading)), getY() + (distance * Math.cos(heading)));			
	}
	
	public class Wave extends Condition {
		Point2D.Double source;
		int[] guessFactors;
		double orbitDirection;
		double absoluteBearing; 
		double radius;
		int weight;
		
		public boolean test() {
			if(enemyLocation.distance(source) <= (radius += 14) + 14) {
				guessFactors[MIDDLE_FACTOR + 
					         (int)(Math.round(Utils.normalRelativeAngle(Math.atan2(enemyLocation.x - source.x, enemyLocation.y - source.y) - absoluteBearing) /
						     orbitDirection))] += weight + 1;
		
				removeCustomEvent(this);
			}
		
			return false;
		}
	}
}