package suh.nano;

import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class TargetR extends AdvancedRobot {
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    execute();
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	double escapeAngle = Math.asin(8.0 / Rules.getBulletSpeed(3));
	double offset = 2.0 * escapeAngle * (Math.random() - 0.5);
	setTurnGunRightRadians(Utils.normalRelativeAngle(bearing + offset - getGunHeadingRadians()));
	setFire(3);
    }
}
