package vuen.cfCake;
import vuen.Cake;
import robocode.*;

public class cRadLock {
	private Cake oRobot = null;
	private cRadControl oRadControl = null;
	private cComControl oComControl = null;
	
	private int CTimeout = 10;

	private int mPhase = 0;
	private String mName = null;
	private boolean mLocked = false;
	private int mTimeout = 0;

	
	public cRadLock(Cake pRobot, cRadControl pRadControl, cComControl pComControl) {
		oRobot = pRobot;
		oRadControl = pRadControl;
		oComControl = pComControl;
	}
	
	public void doInit() {
		mPhase = 0;
		mName = null;
		mLocked = false;
		mTimeout = 0;
		oRobot.setTurnRadarRight(10000);
	}
	
	public void doUnInit() {
	}
	
	public void doTurn() {
		if (mPhase == 0) {
			oRobot.setTurnRadarRight(10000);
		} else if (mPhase == 2) {    //Stay locked on robot...
			if (mTimeout >= CTimeout && mLocked) {
				oRobot.out.println("[" + oRobot.getTime() + "] RAD: " + mName + " track lost! Seeking nearest enemy...");
				oComControl.onLockChange(null);
				oRobot.setTurnRadarRight(10000);
				mPhase = 0;
				mName = null;
				mLocked = false;
			}
			mTimeout += oComControl.mTimeDelta;
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		if (oRobot.isTeammate(e.getName())) return;
		mPhase = 2;
		oRobot.setTurnRadarRight(oRobot.normalRelativeAngle(oRobot.getHeading() + e.getBearing() - oRobot.getRadarHeading()));
		oComControl.doComScannedRobot(e, true);
		mTimeout = 0;
		mLocked = true;
		if (mName == null) {
			mName = e.getName();
			oRobot.out.println("[" + oRobot.getTime() + "] RAD: Locked Radar on " + mName);
		}
	}
}