package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class AntiGravityL extends AdvancedRobot {
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    execute();
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing, power;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	setTurnGunRightRadians(Utils.normalRelativeAngle((bearing + Math.asin(e.getVelocity() * Math.sin(e.getHeadingRadians() - bearing) / Rules.getBulletSpeed(power = 600.0 / e.getDistance()))) - getGunHeadingRadians()));
	setFire(power);
	
	// Movement
	setTurnRightRadians(Utils.normalRelativeAngle(
		Math.atan2(-Math.sin(bearing)/e.getDistance() +1.0/getX() -1.0/(getBattleFieldWidth()-getX()), 
			   -Math.cos(bearing)/e.getDistance() +1.0/getY() -1.0/(getBattleFieldHeight()-getY()))
		-getHeadingRadians()));
	setAhead(120 - Math.abs(getTurnRemaining()));
    }
}
