package trab.utils;
import java.awt.geom.Point2D;

// all trig functions use radians

public class Utils 
{
  public static double scale( double low, double val, double high ) {
    return Math.max( low, Math.min( val, high ) );
  }
  
  public static int gfToIndex( double gf, double factors ) {
    int id = (int)((gf+1)*factors/2);
    id = (int)Math.max( Math.min( factors-1, id ), 0 );
    return id;
  }
  
  public static double maxEscapeAngle( double bulletVelocity )
  {
	  return Math.asin( 8.0D / bulletVelocity );
  }
  
  public static boolean dEquals( double d1, double d2, double treshold ) {
      return d1 + treshold > d2 && d1-treshold < d2;
  }
   
  
  /*
  public static double escapeAngle( double bulletVelocity, double len, int ticks )
  {
	  return Math.asin( (len) / (bulletVelocity*ticks) );
  }
  */
  public static double absoluteBearing( Point2D.Double a, Point2D.Double b )
  {
    return Math.atan2( b.getX() - a.getX(), b.getY() - a.getY() );
  }
  public static double absoluteBearing( Point2D a, Point2D b )
  {
    return Math.atan2( b.getX() - a.getX(), b.getY() - a.getY() );
  }
  /*
  public static double absoluteRoboBearing( Point2D.Double a, Point2D.Double b )
  {
    return Math.atan2( b.getX() - a.getX(), b.getY()-a.getY() );
  }
  */
  public static double sign( double d )
  {
    return d < 0 ? -1 : 1;  
  }
  
  /**
	 * normalAbsoluteAngle:  returns angle such that 0 <= angle < 360
	 */	
	public static double normalAbsoluteAngle(double angle)
	{
		if (angle >= 0 && angle < Math.PI * 2 )
			return angle;
		double fixedAngle = angle;
		while (fixedAngle < 0)
			fixedAngle += Math.PI * 2;
		while (fixedAngle >= Math.PI * 2)
			fixedAngle -= Math.PI * 2;
		return fixedAngle;
	}
	
	/**
	 * normalRelativeAngle:  returns angle such that -180<angle<=180
	 */	
	public static double normalRelativeAngle(double angle)
	{
		if (angle > -Math.PI && angle <= Math.PI)
			return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -Math.PI)
			fixedAngle += Math.PI*2;
		while (fixedAngle > Math.PI)
			fixedAngle -= Math.PI*2;
    return fixedAngle;
  }		
  
  public static double round( double d, int dec )
  {
    dec = (int)Math.pow( 10, dec );
    d *= dec;
    int i = (int)d;
    
    if ( d - i >= 0.5 )
      ++i;
    
    d = i;
    
    return d / dec;
  }
  
  
  public static double sloppyRound( double d, int dec )
  {
    dec = (int)Math.pow( 10, dec );
    d *= dec;
    int i = (int)d;
    
    if ( d - i >= 0.5 )
      ++i;
    
    d = i;
    
    return d / dec;
  }
 
  public static boolean isInRange( double d, double target, double treshold )
  {
    return d < target + treshold && d > target - treshold;
  }
  public static boolean isSorted( double a, double b, double c )
  {
    return (a <= b && b <= c) || (a >= b && b >= c);
  }
  
  /*
  public static double maxForwardDistance( double velocity, int ticks )
  {
    double travel = 0;
    velocity = Math.abs( velocity );
    
    for ( int i = 0; i < ticks; ++i )
    {
      travel += velocity;
      
      if ( velocity < 8 )
        velocity += 1;
    }
    return travel;
  }
  public static double maxBackwardsDistance( double velocity, int ticks )
  {
    double travel = 0;
    velocity = -Math.abs( velocity );
    
    for ( int i = 0; i < ticks; ++i )
    {
      travel += velocity;
      
      if ( velocity < -1 )
        velocity += 2;
      else if ( velocity < 8 )
        velocity += 1;
    }
    return travel;
    
  }*/
  
  public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double len ) {
	  return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * len, sourceLocation.getY() + Math.cos(angle) * len);
  }
  public static Point2D project(Point2D sourceLocation, double angle, double len ) {
	  return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * len, sourceLocation.getY() + Math.cos(angle) * len);
  }
}