package whind;
import java.util.*;
import robocode.*;
import java.awt.geom.*;
/**
 * EnemyWaveMgr - a class by Greywhind
 */
public class EnemyWaveMgr {
	List wavesInAir = new ArrayList();
	static int segmentationLevel = 0;
	// All Stats: No segments.
	static double[] allStats = new double[31];
	// Segmented Stats 1: Acceleration.
	static double[][] segmentedStats1 = new double[5][31];
	// Segmented Stats 2: Near wall, acceleration.
	static double[][][] segmentedStats2 = new double[3][5][31];
	// Segmented Stats 3: Lateral velocity, near wall, acceleration.
	static double[][][][] segmentedStats3 = new double[17][3][5][31];
	// Segmented Stats 4: Time since last direction change, lateral velocity, near wall, acceleration.
	static double[][][][][] segmentedStats4 = new double[10][17][3][5][31];
	static final int NUM_LINES = 3;
	static final int TOTAL_SEGMENTS = 4;
	static final double ROLL_WEIGHT = .01;
	static boolean USE_EMPTY_WAVE_DATA = true;
	int direction, ind, currInd, bulletsInAir;
	static int numPassed;
	boolean hasPassed;
	double lastHitBearing = -1000;
	
	public void updateEnemyWaveMgr(double x, double y, long time, AdvancedRobot robot, ScannedRobotEvent e, double acceleration, double battlefieldheight, double battlefieldwidth, long timesinceswitch, int currentIndex) {
		if (wavesInAir.size() > 0) {
			for (int i=0; i<wavesInAir.size(); i++) {
            	EnemyWave currentWave = (EnemyWave)wavesInAir.get(i);
				ind = currentWave.checkHit(x, y, time);
            	if (ind != -1) {
					currInd = ind;
					if (currentWave.hasBullet == true) {
						hasPassed = true;
						numPassed++;
					} else if (USE_EMPTY_WAVE_DATA == true) {
						numPassed++;
					}
					//onHitByWave(robot, e, acceleration, battlefieldheight, battlefieldwidth, timesinceswitch, currentIndex, -1);
                	onHitByWave(currentWave, currentIndex);
					wavesInAir.remove(currentWave);
                	i--;
				}
        	}
		}
	}
	
	public void addWave(ScannedRobotEvent e, AdvancedRobot robot, double power, double dist, double absBearing, double opposBearing, double ex, double ey, long time, double headRad, double velocity, double acceleration, double battlefieldwidth, double battlefieldheight, long timesinceswitch, boolean bulletCarrying) {
        if (e.getEnergy() == 0.0) {
			return;
		}

		//don't try to figure out the direction we're moving if we're not moving, just use the direction we had before
        if (velocity != 0)
            if (Math.sin(headRad-absBearing)*velocity < 0)
                direction = -1;
            else
                direction = 1;
        //int[] currentStats = allStats;
		double[] statsarray = allStats;
		if (segmentationLevel == 1) {
			statsarray = segmentedStats1[getAccelSegment(acceleration)];
		} else if (segmentationLevel == 2) {
			statsarray = segmentedStats2[getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][getAccelSegment(acceleration)];
		} else if (segmentationLevel == 3) {
			statsarray = segmentedStats3[getLateralVelSegment(robot, e)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][getAccelSegment(acceleration)];
		} else if (segmentationLevel == 4) {
			statsarray = segmentedStats4[getSwitchTimeSegment(timesinceswitch)][getLateralVelSegment(robot, e)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][getAccelSegment(acceleration)];
		}
	
		int[] segmentLoc = new int[TOTAL_SEGMENTS];
		segmentLoc[0] = getAccelSegment(acceleration);
		segmentLoc[1] = getNearWallSegment(robot, battlefieldwidth, battlefieldheight);
		segmentLoc[2] = getLateralVelSegment(robot, e);
		segmentLoc[3] = getSwitchTimeSegment(timesinceswitch);
		
        EnemyWave newWave = new EnemyWave(ex, ey, dist, absBearing, opposBearing, power, direction, time, statsarray, segmentLoc, bulletCarrying);
		wavesInAir.add(newWave);
	}

	public void addWave(ScannedRobotEvent e, AdvancedRobot robot, double power, double dist, double absBearing, double opposBearing, double ex, double ey, long time, double headRad, double velocity, double acceleration, double battlefieldwidth, double battlefieldheight, long timesinceswitch, boolean bulletCarrying, double[] statsarray, int[] segmentLoc) {
        //don't try to figure out the direction we're moving if we're not moving, just use the direction we had before
        if (velocity != 0)
            if (Math.sin(headRad-absBearing)*velocity < 0)
                direction = -1;
            else
                direction = 1;
        //int[] currentStats = allStats;
        EnemyWave newWave = new EnemyWave(ex, ey, dist, absBearing, opposBearing, power, direction, time, statsarray, segmentLoc, bulletCarrying);
		wavesInAir.add(newWave);
	}
	
	// returns the closest bullet that hasn't passed (assuming it is the
	// first one fired that hasn't passed)
	public EnemyWave[] getClosest() {
		bulletsInAir = 0;
		List returnList = new ArrayList();
		EnemyWave[] returnVals;
		if (wavesInAir.size() > 0) {
			int i;
			boolean foundWave = false;
			for (i = 0; i < wavesInAir.size() - 1; i++) {
				// check if has bullet. if so, exit loop.
				EnemyWave thisWave = (EnemyWave)wavesInAir.get(i);
				if (thisWave.hasBullet == true) {
					foundWave = true;
					returnList.add((EnemyWave)wavesInAir.get(i));
					bulletsInAir++;
				}
			}
			returnVals = new EnemyWave[returnList.size()];
			returnVals = (EnemyWave[])returnList.toArray(returnVals);
			return (foundWave == true) ? returnVals : null;
		} else {
			return null;
		}
	}
	
	// returns top 3 likely hit points of the next bullet as
	// Point2D.Doubles in an array.
	public Line2D.Double[][] getExpectedHitPoints() {
		Line2D.Double[][] allPoints;
		EnemyWave[] allBullets = getClosest();

		if (allBullets == null) {
			return null;
		}
		
		allPoints = new Line2D.Double[allBullets.length][NUM_LINES];
		
		// once for each bullet in the air
		for (int a = 0; a < allBullets.length; a++) {
			EnemyWave  closest = allBullets[a];
			Line2D.Double[] thePoints = new Line2D.Double[NUM_LINES];
			
			lastHitBearing = closest.opposBearing;
		
			double bestVal = 0;
			int[] bestIndexes = new int[NUM_LINES];
					
			for (int i = 0; i < allStats.length; i++) {
				if (bestVal < allStats[i]) {
					bestVal = allStats[i];
					for (int x = 0; x < NUM_LINES - 1; x++) {
						bestIndexes[x] = bestIndexes[x + 1];
					}
					bestIndexes[NUM_LINES - 1] = i;
				}
			}
		
			double targetBearing = closest.startBearing;
			double angleOffset;
		
			for (int x = 0; x < NUM_LINES; x++) {
				if (bestIndexes[x] != -1) {
					double guessfactor = (double)(bestIndexes[x]-(allStats.length-1)/2)/((allStats.length-1)/2);
					angleOffset = closest.direction*guessfactor*closest.maxEscapeAngle();
				} else {
					angleOffset = 0;
				}
			
				double hitX = closest.startx + 1400 * Math.sin(targetBearing + angleOffset);
				double hitY = closest.starty + 1400 * Math.cos(targetBearing + angleOffset);
				Line2D.Double thisPoint = new Line2D.Double(closest.startx, closest.starty, hitX, hitY);
				thePoints[x] = thisPoint;
			}
			allPoints[a] = thePoints;
		}
		
		
		return allPoints;
	}
	
	public LineValPair[][] getAllBulletVectors() {
		LineValPair[][] allPoints;
		EnemyWave[] allBullets = getClosest();

		if (allBullets == null) {
			return null;
		}
		
		allPoints = new LineValPair[allBullets.length][31];
		
		// once for each bullet in the air
		for (int a = 0; a < allBullets.length; a++) {
			EnemyWave  closest = allBullets[a];
			LineValPair[] thePoints = new LineValPair[31];
			
			lastHitBearing = closest.opposBearing;
		
			double targetBearing = closest.startBearing;
			double angleOffset;
		
			for (int x = 0; x < 31; x++) {
				double guessfactor = (double)(x-(allStats.length-1)/2)/((allStats.length-1)/2);
				angleOffset = closest.direction*guessfactor*closest.maxEscapeAngle();
			
				double hitX = closest.startx + 1400 * Math.sin(targetBearing + angleOffset);
				double hitY = closest.starty + 1400 * Math.cos(targetBearing + angleOffset);
				Line2D.Double thisPoint = new Line2D.Double(closest.startx, closest.starty, hitX, hitY);
				
				LineValPair thisVal = new LineValPair(thisPoint, (int)smoothedVisits(closest, x));
				// + (x == 15 ? 20 : 0) - add to bias against head-on
				
				thePoints[x] = thisVal;
			}
			allPoints[a] = thePoints;
		}
		
		
		return allPoints;
	}		
	
	public double getBestIndexVal() {
		int bestIndex = 0;
		for (int i = 0; i < allStats.length; i++) {
			if (allStats[i] > allStats[bestIndex]) {
				bestIndex = i;
			}
		}
		
		return allStats[bestIndex];
	}

	public double getBestIndexVal(double[] segvalues) {
		int bestIndex = 0;
		for (int i = 0; i < segvalues.length; i++) {
			if (segvalues[i] > segvalues[bestIndex]) {
				bestIndex = i;
			}
		}
		
		return segvalues[bestIndex];
	}

	public void onHitByBullet(AdvancedRobot robot, ScannedRobotEvent e, double acceleration, double battlefieldheight, double battlefieldwidth, long timesinceswitch, int currentIndex, int segmentLevel) {
		if (segmentLevel == -1) {
			segmentLevel = segmentationLevel;
		}
		
		//allStats[currentIndex] = getBestIndexVal() + 1;
		//segmentedStats1[getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][currentIndex] = getBestIndexVal(segmentedStats1[getNearWallSegment(robot, battlefieldwidth, battlefieldheight)]) + 1;
		//segmentedStats2[getAccelSegment(acceleration)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][currentIndex] = getBestIndexVal(segmentedStats2[getAccelSegment(acceleration)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)]) + 1;
		//segmentedStats3[getLateralVelSegment(robot, e)][getAccelSegment(acceleration)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][currentIndex] = getBestIndexVal(segmentedStats3[getLateralVelSegment(robot, e)][getAccelSegment(acceleration)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)]) + 1;
		/*allStats[currentIndex]++;
		segmentedStats1[getAccelSegment(acceleration)][currentIndex]++;
		segmentedStats2[getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][getAccelSegment(acceleration)][currentIndex]++;
		segmentedStats3[getLateralVelSegment(robot, e)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][getAccelSegment(acceleration)][currentIndex]++;*/
		for (int i = 0; i <= TOTAL_SEGMENTS; i++) {
			double[] currSegment = getCurrentSegment(robot, e, acceleration, battlefieldheight, battlefieldwidth, timesinceswitch, i);
			currSegment[currentIndex] += (100 * (robot.getRoundNum()+1)) * (1 + ROLL_WEIGHT * numPassed);
		}
		
		
		if (segmentationLevel != getBestSegmentLevel()) {
			System.out.println("Switching to segmentation level " + getBestSegmentLevel());
			segmentationLevel = getBestSegmentLevel();
		}
	}

	public void onHitByWave(AdvancedRobot robot, ScannedRobotEvent e, double acceleration, double battlefieldheight, double battlefieldwidth, long timesinceswitch, int currentIndex, int segmentLevel) {
		// CALLED WHEN HIT BY AN EMPTY WAVE.	
		if (USE_EMPTY_WAVE_DATA == false) {
			return;
		}
			
		if (segmentLevel == -1) {
			segmentLevel = segmentationLevel;
		}
		
		//allStats[currentIndex] = getBestIndexVal() + 1;
		//segmentedStats1[getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][currentIndex] = getBestIndexVal(segmentedStats1[getNearWallSegment(robot, battlefieldwidth, battlefieldheight)]) + 1;
		//segmentedStats2[getAccelSegment(acceleration)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][currentIndex] = getBestIndexVal(segmentedStats2[getAccelSegment(acceleration)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)]) + 1;
		//segmentedStats3[getLateralVelSegment(robot, e)][getAccelSegment(acceleration)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][currentIndex] = getBestIndexVal(segmentedStats3[getLateralVelSegment(robot, e)][getAccelSegment(acceleration)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)]) + 1;
		/*allStats[currentIndex]++;
		segmentedStats1[getAccelSegment(acceleration)][currentIndex]++;
		segmentedStats2[getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][getAccelSegment(acceleration)][currentIndex]++;
		segmentedStats3[getLateralVelSegment(robot, e)][getNearWallSegment(robot, battlefieldwidth, battlefieldheight)][getAccelSegment(acceleration)][currentIndex]++;*/
		for (int i = 0; i <= TOTAL_SEGMENTS; i++) {
			double[] currSegment = getCurrentSegment(robot, e, acceleration, battlefieldheight, battlefieldwidth, timesinceswitch, i);
			currSegment[currentIndex] += 1 + ROLL_WEIGHT * numPassed;
		}
		
		if (segmentationLevel != getBestSegmentLevel()) {
			System.out.println("Switching to segmentation level " + getBestSegmentLevel());
			segmentationLevel = getBestSegmentLevel();
		}
	}

	public void onHitByWave(EnemyWave wave, int currentIndex) {
		int[] loc = wave.segmentLocation;
		double val = 1 + ROLL_WEIGHT * numPassed;
		allStats[currentIndex] += val;
		segmentedStats1[loc[0]][currentIndex] += val;
		segmentedStats2[loc[1]][loc[0]][currentIndex] += val;
		segmentedStats3[loc[2]][loc[1]][loc[0]][currentIndex] += val;
		segmentedStats4[loc[3]][loc[2]][loc[1]][loc[0]][currentIndex] += val;
		
		if (segmentationLevel != getBestSegmentLevel()) {
			System.out.println("Switching to segmentation level " + getBestSegmentLevel());
			segmentationLevel = getBestSegmentLevel();
		}
	}

	public void onHitByBullet(AdvancedRobot robot, EnemyWave wave, int currentIndex) {
		int[] loc = wave.segmentLocation;
		double val = (100 * (robot.getRoundNum()+1)) * (1 + ROLL_WEIGHT * numPassed);
		allStats[currentIndex] += val;
		segmentedStats1[loc[0]][currentIndex] += val;
		segmentedStats2[loc[1]][loc[0]][currentIndex] += val;
		segmentedStats3[loc[2]][loc[1]][loc[0]][currentIndex] += val;
		segmentedStats4[loc[3]][loc[2]][loc[1]][loc[0]][currentIndex] += val;
		
		if (segmentationLevel != getBestSegmentLevel()) {
			System.out.println("Switching to segmentation level " + getBestSegmentLevel());
			segmentationLevel = getBestSegmentLevel();
		}
	}
	
	public int getLateralVelSegment(AdvancedRobot robot, ScannedRobotEvent e) {
		return 8 + Math.round((float)(robot.getVelocity() * Math.sin(e.getHeadingRadians() - (e.getBearingRadians() + robot.getHeadingRadians()))));
	}

	public int getAccelSegment(double acceleration) {
		int accelseg = 2 + Math.round((float)acceleration);
		if (accelseg < 0) {
			accelseg = 0;
		}
		if (accelseg > 4) {
			accelseg = 4;
		}
		return accelseg;
	}

	public int getNearWallSegment(AdvancedRobot robot, double battlefieldwidth, double battlefieldheight) {
		int nearwallsegment = 0;
		if (robot.getX() < 200 | robot.getX() > (battlefieldwidth - 200)) {
			nearwallsegment += 1;
		}
		if (robot.getY() < 200 | robot.getY() > (battlefieldheight - 200)) {
			nearwallsegment += 1;
		}
		return nearwallsegment;
	}

	public int getSwitchTimeSegment(long timeSinceSwitch) {
		if (timeSinceSwitch > 60) {
			timeSinceSwitch = 60;
		}
		int timeSinceSwitchSeg = (int)(timeSinceSwitch/60.0);
		if (timeSinceSwitchSeg > 9) {
			timeSinceSwitchSeg = 9;
		}
		return timeSinceSwitchSeg;
	}

	public double getCurrentSegmentVal(AdvancedRobot robot, ScannedRobotEvent e, double acceleration, double battlefieldheight, double battlefieldwidth, long timesinceswitch, int currentIndex, int segmentLevel) {
		if (segmentLevel == -1) {
			segmentLevel = segmentationLevel;
		}
		double[] currSegment = getCurrentSegment(robot, e, acceleration, battlefieldheight, battlefieldwidth, timesinceswitch, segmentLevel);
		return currSegment[currentIndex];
	}

	public double[] getCurrentSegment(AdvancedRobot robot, ScannedRobotEvent e, double acceleration, double battlefieldheight, double battlefieldwidth, long timesinceswitch, int segmentLevel) {
		if (segmentLevel == -1) {
			segmentLevel = segmentationLevel;
		}
		int lateralvelsegment = getLateralVelSegment(robot, e);
		int accelsegment = getAccelSegment(acceleration);
		int nearwallsegment = getNearWallSegment(robot, battlefieldwidth, battlefieldheight);
		int switchtimesegment = getSwitchTimeSegment(timesinceswitch);
		
		//System.out.println("Near Wall: " + nearwallsegment + " Acceleration: " + accelsegment + " Lateral Velocity: " + lateralvelsegment);
		if (segmentLevel == 1) {
			return segmentedStats1[accelsegment];
		} else if (segmentLevel == 2) {
			return segmentedStats2[nearwallsegment][accelsegment];
		} else if (segmentLevel == 3) {
			return segmentedStats3[lateralvelsegment][nearwallsegment][accelsegment];
		} else if (segmentLevel == 4) {
			return segmentedStats4[switchtimesegment][lateralvelsegment][nearwallsegment][accelsegment];
		} else {
			return allStats;
		}
	}

	int getSegmentLevel() {
		return segmentationLevel;
	}

	int getBestSegmentLevel() {
		int totalBins1 = 0;
		int binsFilled1 = 0;
		double maxBin1 = 0;
		for (int a = 0; a < segmentedStats1.length; a++) {
			for (int b = 0; b < segmentedStats1[0].length; b++) {
				totalBins1++;
				if (segmentedStats1[a][b] != 0) {
					binsFilled1++;
					if (segmentedStats1[a][b] > maxBin1) {
						maxBin1 = segmentedStats1[a][b];
					}
				}
			}
		}
		
		int totalBins2 = 0;
		int binsFilled2 = 0;
		double maxBin2 = 0;
		for (int a = 0; a < segmentedStats2.length; a++) {
			for (int b = 0; b < segmentedStats2[0].length; b++) {
				for (int c = 0; c < segmentedStats2[0][0].length; c++) {
					totalBins2++;
					if (segmentedStats2[a][b][c] != 0) {
						binsFilled2++;
						if (segmentedStats2[a][b][c] > maxBin2) {
							maxBin2 = segmentedStats2[a][b][c];
						}
					}
				}
			}
		}
	
		int totalBins3 = 0;
		int binsFilled3 = 0;
		double maxBin3 = 0;
		for (int a = 0; a < segmentedStats3.length; a++) {
			for (int b = 0; b < segmentedStats3[0].length; b++) {
				for (int c = 0; c < segmentedStats3[0][0].length; c++) {
					for (int d = 0; d < segmentedStats3[0][0][0].length; d++) {
						totalBins3++;
						if (segmentedStats3[a][b][c][d] != 0) {
							binsFilled3++;
							if (segmentedStats3[a][b][c][d] > maxBin3) {
								maxBin3 = segmentedStats3[a][b][c][d];
							}
						}
					}
				}
			}
		}
	
		int totalBins4 = 0;
		int binsFilled4 = 0;
		double maxBin4 = 0;
		for (int a = 0; a < segmentedStats4.length; a++) {
			for (int b = 0; b < segmentedStats4[0].length; b++) {
				for (int c = 0; c < segmentedStats4[0][0].length; c++) {
					for (int d = 0; d < segmentedStats4[0][0][0].length; d++) {
						for (int e = 0; e < segmentedStats4[0][0][0][0].length; e++) {
							totalBins4++;
							if (segmentedStats4[a][b][c][d][e] != 0) {
								binsFilled4++;
								if (segmentedStats4[a][b][c][d][e] > maxBin4) {
									maxBin4 = segmentedStats4[a][b][c][d][e];
								}
							}
						}
					}
				}
			}
		}
	
		/*
		System.out.println("Level 1: (total bins " + totalBins1 + ") Has " + binsFilled1 + " bins filled (" + (((double)binsFilled1 / totalBins1) * 100) + "% data), max point is " + maxBin1 + " (" + (((double)maxBin1 / totalBins1) * 100) + "%)");
		System.out.println("Level 2: (total bins " + totalBins2 + ") Has " + binsFilled2 + " bins filled (" + (((double)binsFilled2 / totalBins2) * 100) + "% data), max point is " + maxBin2 + " (" + (((double)maxBin2 / totalBins2) * 100) + "%)");
		System.out.println("Level 3: (total bins " + totalBins3 + ") Has " + binsFilled3 + " bins filled (" + (((double)binsFilled3 / totalBins3) * 100) + "% data), max point is " + maxBin3 + " (" + (((double)maxBin3 / totalBins3) * 100) + "%)");
		System.out.println("Level 4: (total bins " + totalBins4 + ") Has " + binsFilled4 + " bins filled (" + (((double)binsFilled4 / totalBins4) * 100) + "% data), max point is " + maxBin4 + " (" + (((double)maxBin4 / totalBins4) * 100) + "%)");
		*/
		
		if (binsFilled4 > .055 * totalBins4) {
			return 4;
		}
	
		if (binsFilled3 > .30 * totalBins3) {
			return 3;
		}
	
		if (binsFilled2 > .50 * totalBins2) {
			return 2;
		}
	
		if (binsFilled1 > .75 * totalBins1) {
			return 1;
		}
	
		return 0;
	}
	
	double smoothedVisits(int index) {
    	double smoothed = 0;
    	if (index > 0) {
        	smoothed += allStats[index - 1] / 2;
    	}
    	if (index < allStats.length - 1) {
        	smoothed += allStats[index + 1] / 2;
    	}
    	smoothed += allStats[index];
    	return smoothed;
	}

	double smoothedVisits(EnemyWave wave, int index) {
    	double smoothed = 0;
    	if (index > 0) {
        	smoothed += wave.returnSegment[index - 1] / 2;
    	}
    	if (index < allStats.length - 1) {
        	smoothed += wave.returnSegment[index + 1] / 2;
    	}
    	smoothed += wave.returnSegment[index];
    	return smoothed;
	}
}