package zyx.mega.targeting.melee;


import static java.lang.Math.PI;
import static java.lang.Math.min;
import static java.util.Collections.sort;
import static robocode.Rules.MIN_BULLET_POWER;
import static robocode.util.Utils.normalRelativeAngle;
import static zyx.mega.bot.Enemy.alive_enemies_;
import static zyx.mega.bot.Enemy.closest_;
import static zyx.mega.bot.Enemy.last_seen_;
import static zyx.mega.geometry.Geometry.PI_9;
import static zyx.mega.utils.Range.CapLowHigh;
import static zyx.mega.utils.Range.Normalize;
import static zyx.mega.utils.RoboUtils.PredictMyPosition;
import static zyx.mega.utils.TurnHandler.AimGun;
import static zyx.mega.utils.TurnHandler.FireBullet;
import static zyx.mega.utils.TurnHandler.me_;
import static zyx.mega.utils.TurnHandler.others_;
import static zyx.mega.utils.TurnHandler.robot_;
import static zyx.mega.utils.TurnHandler.ticks_to_fire_;
import static zyx.mega.utils.TurnHandler.time_;
import static zyx.mega.utils.wave.WaveHit.ALL_IN;
import static zyx.mega.utils.wave.WaveHit.ALL_OUT;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import zyx.debug.painter.Painter;
import zyx.mega.bot.Bot;
import zyx.mega.bot.Enemy;
import zyx.mega.bot.MeleeEnemy;
import zyx.mega.geometry.Line;
import zyx.mega.utils.DangerSwitch;
import zyx.mega.utils.Range;

public class MeleeGun {
  public static boolean _paint_;
  private LinkedList<MeleeShootingWave> waves_;
  private MeleeShootingWave next_wave_;
  
  public MeleeGun() {
    waves_ = new LinkedList<MeleeShootingWave>();
  }
  public void Init() {
    waves_.clear();
  }
  
  public void run() {
    double power = FirePower();
    if ( next_wave_ != null ) {
      if ( FireBullet(min(power, next_wave_.fire_power_), closest_) != null ) {
      }
      next_wave_.SetPoint(me_);
      next_wave_.time_ = time_;
      waves_.add(next_wave_);
    } else FireBullet(power, closest_);
    UpdateWaves();
    double aim_angle_ = 0;
    if ( ticks_to_fire_ > 0 && ticks_to_fire_ < 10 && power > 0 ) {
      next_wave_ = new MeleeShootingWave();
      next_wave_.SetPower(power);
      //System.out.println("  need to aim");
      Bot firing_me = PredictMyPosition(ticks_to_fire_);
      double tank_turn = firing_me.heading_ - me_.heading_;
      Range reachable = new Range(
          normalRelativeAngle(robot_.getGunHeadingRadians() + tank_turn) - PI_9 * ticks_to_fire_,
          normalRelativeAngle(robot_.getGunHeadingRadians() + tank_turn) + PI_9 * ticks_to_fire_);
      if ( _paint_ ) {
        firing_me.bbox_.Update();
        //if ( _paint_ ) Painter.Add(firing_me.bbox_, new Color(64, 64, 64, 128));
        //if ( _paint_ ) Painter.Add(new Arc(firing_me, 800, reachable.window_[0], reachable.window_[1]), new Color(64, 128, 252, 128));
      }
      ArrayList<DangerSwitch> array = new ArrayList<DangerSwitch>();
      long max_time = time_ - last_seen_.scan_time_;
      for ( int e = 0; e < others_; ++e ) {
        MeleeEnemy menemy = alive_enemies_[e];
        //System.out.println(menemy.bot_.name_ + " is still alive");
        Enemy enemy = menemy.bot_;
        double weight = 1000 / enemy.distance_ * 
        CapLowHigh(1 / enemy.energy_ratio_, 0.3, 2) *
        ((1 - Normalize(time_ - enemy.scan_time_, -1, max_time, false)) * 0.3 + 0.7);
        //if ( getBulletDamage(power) > enemy.energy_ - 1e-9 ) weight *= 1.2;
        double circular_weight = ((1 - Normalize(enemy.scans_difference_, 0, 7, false)) * 0.8 + 0.2) * 0.5;
        //System.out.println(weight);
        Bot hot = new Bot(enemy);
        Bot linear = hot;
        Bot circular = hot;
        //System.out.println("  have hot");
        if ( enemy.energy_ > 0 ) {
          linear = enemy.LinearPrediction(firing_me, (int)(enemy.scan_time_ - time_), ticks_to_fire_, power);
          circular = enemy.CircularPrediction(firing_me, (int)(enemy.scan_time_ - time_), ticks_to_fire_, power);
          Range hot_window = firing_me.CornersAngleWindow(enemy);
          Range linear_window = firing_me.CornersAngleWindow(linear);
          Range circular_window = firing_me.CornersAngleWindow(circular);
          double total = 0; for ( double s : enemy.melee_gun_scores_ ) total += s; 
          if ( total == 0 ) continue;
          total = 2 / total;
          AddWindow(array, hot_window, weight * enemy.melee_gun_scores_[0] * total);
          AddWindow(array, linear_window, weight * enemy.melee_gun_scores_[1] * total);
          AddWindow(array, circular_window, weight * circular_weight * enemy.melee_gun_scores_[2] * total);
          next_wave_.shots_.add(new MeleeVShot(enemy, hot, 0));
          next_wave_.shots_.add(new MeleeVShot(enemy, linear, 1));
          next_wave_.shots_.add(new MeleeVShot(enemy, circular, 2));
          if ( _paint_ ) {
            Painter.Add(new Line(enemy, hot), Color.YELLOW);
            Painter.Add(new Line(enemy, linear), Color.RED);
            linear.bbox_.Update();
            Painter.Add(linear.bbox_, Color.RED);
            Painter.Add(new Line(enemy, circular), Color.WHITE);
            circular.bbox_.Update();
            Painter.Add(circular.bbox_, Color.WHITE);
          }
        } else {
          Range hot_window = firing_me.CornersAngleWindow(enemy);
          for ( double w : enemy.melee_gun_scores_ ) weight *= w;
          AddWindow(array, hot_window, weight);
        }
      }
      //System.out.println("  have them all");
      sort(array);
      //System.out.println("  sorted");
      aim_angle_ = (array.get(0).factor_ + array.get(1).factor_) / 2;
      double danger = array.get(0).danger_;
      double best_danger = danger;
      for ( int j = 1; j < array.size() - 1; ++j ) {
        double angle = (array.get(j).factor_ + array.get(j + 1).factor_) / 2;
        danger += array.get(j).danger_;
        if ( danger > best_danger && (reachable.Inside(angle) ||
              reachable.Inside(array.get(j).factor_) || 
              reachable.Inside(array.get(j + 1).factor_)) ) {
          aim_angle_ = angle;
          best_danger = danger;
        }
      }
      //System.out.println("  have aim angle");
      if ( _paint_ ) Painter.Add(new Line(firing_me, aim_angle_, 1200), Color.WHITE);
    } else if ( closest_ != null ) {
      //System.out.println("  aiming at closest");
      if ( _paint_ && closest_ != null ) Painter.Add(closest_, 18, Color.YELLOW);
      aim_angle_ = closest_.bearing_;
    }
    AimGun(aim_angle_);
  }
  private void UpdateWaves() {
    //if ( waves_.size() > 0 ) System.out.println("num waves: " + waves_.size());
    for ( Iterator<MeleeShootingWave> it = waves_.iterator(); it.hasNext(); ) {
      MeleeShootingWave wave = it.next();
      wave.Update(time_);
      if ( _paint_ ) Painter.Add(wave, Color.BLUE);
      for ( Iterator<MeleeVShot> it2 = wave.shots_.iterator(); it2.hasNext(); ) {
        //System.out.println("Start 2");
        MeleeVShot vshot = it2.next();
        Enemy enemy = vshot.enemy_;
        if ( enemy.scan_time_ < time_ ) {
          //System.out.println("End 2, abrupt 1");
          continue;
        }
        int info  = wave.HitInfo(enemy);
        //System.out.println(info + " " + enemy.distance(wave) + " " + wave.radius_);
        if ( info == ALL_OUT ) {
          //if ( _paint_ ) Painter.Add(enemy, Color.BLUE);
          //System.out.println("End 2, abrupt 2");
          continue;
        }
        if ( info == ALL_IN ) {
          if ( _paint_ ) Painter.Add(enemy, Color.RED);
          if ( vshot.previous_ == ALL_OUT ) {
            vshot.FindHitRange(wave);
          } else {
            vshot.FindHitEnd(wave);
          }
          enemy.UpdateMeleeGunScore(vshot.gun_, vshot.best_);
          it2.remove();
        } else {
          if ( _paint_ ) Painter.Add(enemy, Color.BLACK);
          if ( vshot.previous_ == ALL_OUT ) {
            vshot.FindHitStart(wave);
          } else {
            vshot.InterpolateAll();
          }
        }
        //System.out.println("End 2");
      }
      //System.out.println("End");
    }
  }
  private void AddWindow(ArrayList<DangerSwitch> array, Range window, double weight) {
    if ( window.Size() < PI ) {
      array.add(new DangerSwitch(window.window_[0], weight));
      array.add(new DangerSwitch(window.window_[1], -weight));
    } else {
      array.add(new DangerSwitch(window.window_[1], weight));
      array.add(new DangerSwitch(PI, -weight));
      array.add(new DangerSwitch(-PI, weight));
      array.add(new DangerSwitch(window.window_[0], -weight));
    }
  }
  private double FirePower() {
    double power = 3;
    if ( closest_ != null && closest_.distance_ < 120 ) {
      if ( me_.energy_ < 10 )power = 1;
      else if ( me_.energy_ < 25 )power = 2;
    } else if ( others_ < 3 ) {
      if ( me_.energy_ < 20 )power = 0.5;
      else if ( me_.energy_ < 40 )power = 1;
      else power = 1.9;
    } else if ( others_ < 4 ) {
      if ( me_.energy_ < 20 )power = 0.5;
      else if ( me_.energy_ < 40 )power = 0.9;
      else power = 1;
    } else if ( others_ < 5 ) {
      if ( me_.energy_ < 20 )power = 1;
      else if ( me_.energy_ < 40 )power = 1.5;
      else power = 2;
    } else if ( others_ < 7 ) {
      if ( me_.energy_ < 20 )power = 1;
      else if ( me_.energy_ < 40 )power = 2;
      else power = 2.5;
    } else {
      if ( me_.energy_ < 10 )power = 1;
      else if ( me_.energy_ < 25 )power = 2;
    }
    //power = min(power, me_.energy_ / 6);
    //if ( others_ < 4 && me_.energy_ < 30 ) power = min(power, 1);
    //if ( others_ < 5 && me_.energy_ < 20 ) power = min(power, 0.5);
    if ( me_.energy_ < 1 && closest_.distance_ > 120 ) power = 0;
    else if ( me_.energy_ < 50 && closest_.distance_ > 750 &&
        closest_.energy_ratio_ > 1 && time_ - closest_.last_hit_time_ > -10 ) power = 0;
    else if ( me_.energy_ < 25 && closest_.distance_ > 600 &&
        closest_.energy_ratio_ > 1  && time_ - closest_.last_hit_time_ > -10 ) power = 0;
    else if ( power < MIN_BULLET_POWER ) power = 0;
    else if ( me_.energy_ - power < MIN_BULLET_POWER && 
        !((closest_.distance_ < 200 && closest_.energy_ratio_ > 1) ||
            (closest_.distance_ < 85)) ) power = 0;
    return power;
  }
}
