package kc.micro.rammer;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.util.Utils;

/**
 MaxRisk - a robot by Kev
 	Generates points in a circle to determine the best direction (like minimum risk movement)...
 	...but it's a ram bot!
    748 bytes with colors + dance
 */
public class MaxRisk extends AdvancedRobot
{
	double absoluteBearing;
	double expectedHeading;
	double predictedDistance;
	double predictedHeading;
	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.red.darker().darker(), Color.red.darker(), Color.red);
		do{
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}while(true);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double predictedX = getX() + (Math.sin(absoluteBearing = (getHeadingRadians() + e.getBearingRadians())) * e.getDistance());
		double predictedY = getY() + (Math.cos(absoluteBearing) * e.getDistance()); 
		double enemyTurnRate = -Utils.normalRelativeAngle(expectedHeading - (predictedHeading = expectedHeading = e.getHeadingRadians()));
		double bulletPower = Math.min(e.getDistance() < 250 ? 500/e.getDistance() : 200/e.getDistance(), 3);
		int time = 0;
		while((time++) * (20 - (3 * bulletPower)) < (predictedDistance = Point2D.Double.distance(getX(), getY(), predictedX, predictedY)) - 18)
		{	
			predictedHeading += (enemyTurnRate / 3);
			predictedX += Math.sin(predictedHeading) * e.getVelocity();	
			predictedY += Math.cos(predictedHeading) * e.getVelocity();
			if((predictedX < 18.0)||(predictedY < 18.0)||(predictedX > 782.0)||(predictedY > 582.0))
			{		
				predictedX = Math.min(Math.max(18.0, predictedX), 782.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), 582.0);
				break;
			}
		}
		double maxValue = Double.NEGATIVE_INFINITY;
		for(double i = 0; i < 6.3; i+= 0.1)
		{
			double relativeTurn = Utils.normalRelativeAngle(i - getHeadingRadians());
			int virtualDirection = 1;
			if(relativeTurn < -Math.PI/2)
			{
				relativeTurn += Math.PI;
				virtualDirection = -1;
			}
			if(relativeTurn > Math.PI/2)
			{
				relativeTurn -= Math.PI;
				virtualDirection = -1;
			}
			double tryX = getX() + (Math.sin(i) * 8.0);
			double tryY = getY() + (Math.cos(i) * 8.0);
			double value = Math.abs(Math.cos(Utils.normalRelativeAngle(absoluteBearing-i))) * e.getDistance() / 150;
			value += (predictedDistance - Point2D.Double.distance(tryX, tryY, predictedX, predictedY));
			value -= ((Point2D.Double.distance(tryX,tryY, 400.0, 300.0) - Point2D.Double.distance(getX(), getY(), 300.0, 400.0))) / 3;
			if(tryX < 30.0 || tryY < 30.0 || tryX > 770.0 || tryY > 570.0){value -= 10000;}
			if(value > maxValue)
			{
				maxValue = value;
				setTurnRightRadians(relativeTurn);
				setAhead(1000 * virtualDirection);
			} 
		}	
		setMaxVelocity(Math.abs(getTurnRemaining()) < 30 ? 8 : 8 - Math.abs(getTurnRemaining()/30));
		double gunTurn = Utils.normalRelativeAngle(Math.atan2(predictedX - getX(), predictedY - getY()) - getGunHeadingRadians());
		setTurnGunRightRadians(gunTurn);
		double radarTurn = Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians());
		setTurnRadarRightRadians(radarTurn + (radarTurn > 0 ? Math.PI/8 : -Math.PI/8));
		if((Math.abs(gunTurn) < 0.35)&&(getGunHeat() == 0.0))
		{
			setFire(bulletPower);
		}
	}
	public void onWin(WinEvent e)
	{
		setMaxVelocity(0);
		setTurnRightRadians(Double.POSITIVE_INFINITY);
		setTurnGunRightRadians(Double.NEGATIVE_INFINITY);
	}
}
