package nat.gfx;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

public final class RobocodeGraphics {
	private ArrayList<GraphicsLayer> layers;
	
	public RobocodeGraphics() {
		layers = new ArrayList<GraphicsLayer>();
	}
	
	public GraphicsLayer getLayer(String name, int key) {
		for (GraphicsLayer layer : layers) {
			if (layer.name.equals(name)) {
				return layer;
			}
		}
		GraphicsLayer layer = new GraphicsLayer(name, key);
		layers.add(layer);
		return layer;
	}
	
	public void onPaint(Graphics2D g) {
		for (GraphicsLayer layer : layers) {
			if (layer.paint) {
				layer.render(g);
			}
			layer.clear();
		}
	}
	
	public void onKeyPressed(KeyEvent e) {
		int key = e.getKeyCode();
		for (GraphicsLayer layer : layers) {
			if (key == layer.key) {
				layer.paint = !layer.paint;
			}
		}
	}
}
