/**
 * Copyright (c) 2009 Nat Pavasant; All right reserved.
 * Source code is released under the term of Nat Public Robot License 2.1
 */
package nat.utils;

/**
 * @author Nat Pavasant
 */
public class Vector extends Point implements java.io.Serializable, Cloneable {
	private static final long serialVersionUID = -924974801206821046L;
	public double angle, magnitude;

	public Vector(double angle, double magnitude) {
		super(0, 0);
		setVector(angle, magnitude);
	}
	
	private Vector(){ super(0,0); }
	public static Vector fromXY(double x, double y) {
		Vector a = new Vector();
		a.setLocation(x,y);
		return a;
	}

	public void setLocation(double x, double y) {
		super.setLocation(x, y);
		recalculateVector();
	}

	public void setVector(double angle, double magnitude) {
		this.angle = angle;
		this.magnitude = magnitude;
		recalculateLocation();
	}
	
	public void turn(double angle) {
		this.angle += angle;
		recalculateLocation();
	}
	
	public void add(Vector vector) {
		this.x += vector.x;
		this.y += vector.y;
		recalculateVector();
	}

	public void recalculateVector() {
		angle = this.distance(0, 0);
		magnitude = M.atan2(x, y);
	}

	public void recalculateLocation() {
		x = magnitude * M.sin(angle);
		y = magnitude * M.cos(angle);
	}
}
