package gadsky;

public final class Me {
	public final long time;
	public final double energy;
	public final double bodyAngle;
	private final double gunAngle;
	private final double radarAngle;
	public final Vector2D position;
	public final Vector2D speed;
	public final Vector2D bodyDirection;
	public final Vector2D gunDirection;
	public final Vector2D radarDirection;
	public final double iWillFireIn;

	public Me(Gadsky robot) {
		time = robot.getTime();
		energy = robot.getEnergy();
		bodyAngle = Tools.normalize(robot.getHeadingRadians());
		gunAngle = Tools.normalize(robot.getGunHeadingRadians());
		radarAngle = Tools.normalize(robot.getRadarHeadingRadians());
		position = new Vector2D(robot.getX(), robot.getY());
		bodyDirection = Vector2D.EX.rotated(bodyAngle);
		gunDirection = Vector2D.EX.rotated(gunAngle);
		radarDirection = Vector2D.EX.rotated(radarAngle);
		speed = bodyDirection.mul(robot.getVelocity());
		iWillFireIn = robot.getGunHeat() / robot.getGunCoolingRate();
	}
}
