package cx.util.iiley;
import java.awt.geom.Point2D;
import java.io.Serializable;
import robocode.*;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * Infinity Virtule Bullets looks like a wave
 * 30 different velocity of wave become a MultiWave
 */

public class MultiWave// implements Serializable
{
	private AdvancedRobot robot;
	//--------------------state define--------
	public static final double Traveling=10d;
	public static final double Useless=20d;
	public static final double Hit=30d;
	//-------comparable varialbles
	private double linePreDiffAngle;
	private double distance;
	public double distanceToCenter;
	//-----------
	public double isFired;
	private double startX;
	private double startY;
	private long startTime;
	private double absBearing;
	private static double[] velocitys={
		19.7,19.4,19.1,18.8,18.5,18.2,17.9,17.6,17.3,17.0,
		16.7,16.4,16.1,15.8,15.5,15.2,14.9,14.6,14.3,14.0,
		13.7,13.4,13.1,12.8,12.5,12.2,11.9,11.6,11.3,11.0};  //30 unit of velocitys for 30 power bullet
	private double[] willHitDistances;
	public double[] willHitDiffAngles={
		Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,
		Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,
		Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling,Traveling};//30 unit of willHitDiffAngles for 30 power bullet
	//----
	public double state;
    public MultiWave(){
		willHitDistances=new double[30];
	}
	public MultiWave(double x,double y,boolean isFired,long time,double bearing,double dist,double lpda,double distanceToCenter){
		this.isFired=isFired ? -0.1 : 0;
		absBearing=bearing;
		distance=dist/90d;
        linePreDiffAngle=lpda;
		this.distanceToCenter=distanceToCenter;
		startX=x;
		startY=y;
        startTime=time;
        willHitDistances=new double[30];
		for(int i=0;i<30;i++) willHitDistances[i]=100000;  //very large

		state=Traveling;
	}
	public void setFired(boolean isFired){
		this.isFired=isFired ? -0.1 : 0;
	}
	public long getTime(){
		return startTime;
	}
	public static double getComVal(Object o,Object o2){     //use for pattern analyser
		MultiWave curWave=(MultiWave)o;
		MultiWave comWave=(MultiWave)o2;
        return Point2D.distanceSq(curWave.linePreDiffAngle,curWave.distance,comWave.linePreDiffAngle,comWave.distance)
			   +Math.pow((curWave.distanceToCenter-comWave.distanceToCenter),2);
	}
	public static double getComValD(Object o,Object o2){     //use for pattern analyser
		MultiWave curWave=(MultiWave)o;
		MultiWave comWave=(MultiWave)o2;
        return Point2D.distanceSq(curWave.linePreDiffAngle,curWave.distance,-comWave.linePreDiffAngle,comWave.distance)
			   +Math.pow((curWave.distanceToCenter-comWave.distanceToCenter),2);
	}
	public static int getIndex(double power){
		int index=((int)Math.round(power*10))-1;
		if(index<0) index=0;
		if(index>29) index=29;
		return index;
	}
	public boolean isHit(double power){
        return willHitDiffAngles[getIndex(power)]<10d;
	}
	public double getWillHitDiffAngle(double power){
    	return willHitDiffAngles[getIndex(power)];
	}
	public double getWillHitDistance(double power){
		return willHitDistances[getIndex(power)];
	}
	/**
	 * @return a wave contains the willHitdiffAngles as result
	 */
	public MultiWave resultWave(double dir){
		MultiWave rw=new MultiWave();
		for(int i=0;i<30;i++){
			rw.willHitDiffAngles[i]=willHitDiffAngles[i]*dir;
		}
		return rw;
	}
	/**
	 * the robot is death,so it willHitDiffAngles all = 0
	 * you'd best call this method to a resultWave not the wave in wavs vector
	 */
	public void setDeath(){
		for(int i=0;i<30;i++){
			willHitDiffAngles[i]=0d;
		}
	}
	/**
	* return is test completed
	*/
	public boolean test(double ex,double ey,long time){
		if(state==Traveling){//it is not a finished wave,so test
		    double dist=Point2D.distance(startX,startY,ex,ey);
			double disTime=time-startTime;
			if (disTime<0){
				state=Useless;  //express this is a useless MultiWave
				return true;
			}else{
				for(int i=0;i<30;i++){     //test all power bullet
					if(willHitDiffAngles[i]==Traveling){
						if(Math.abs(dist-velocitys[i]*disTime)<18){
             				willHitDiffAngles[i]=standardAngle(Math.atan2(ex-startX,ey-startY)-absBearing);
                            willHitDistances[i]=dist;
							if(i==29){ 
								state=Hit;          //if the slowest bullet hit the enmey,means all bullet hit
					           	return true;
							}
						}
					}
				}
			}
			return false;
		}else{
			return true;
		}
	}
	public static double standardAngle( double ang ) {	//get the relative angle where - PI < angle < PI
		return Math.atan2( Math.sin( ang ), Math.cos( ang ) );
	}
};
