package simonton.utils;

import java.awt.Graphics2D;
import java.awt.geom.*;
import java.util.*;

import robocode.*;
import simonton.core.*;
import simonton.guns.Gun;

public class Util {

	public static Rectangle2D.Double botBounds;
	public static LinkedList<Wave> enemyWaves;
	public static LinkedList<Wave> myWaves;
	public static Point2D.Double enemyP;
	public static Point2D.Double myP;
	public static Wave deletedEnemyWave;
	public static Wave addedEnemyWave;
	public static double worldWidth;
	public static double worldHeight;
	public static double gunCoolingRate;
	public static double[] cos = new double[360];
	public static double[] sin = new double[360];
	public static int time;
	static {
		for (int i = 0; i < 360; ++i) {
			cos[i] = Math.cos(Math.toRadians(i));
			sin[i] = Math.sin(Math.toRadians(i));
		}
	}

	public static void startRound(AdvancedRobot robot) {
		worldWidth = robot.getBattleFieldWidth();
		worldHeight = robot.getBattleFieldHeight();
		gunCoolingRate = robot.getGunCoolingRate();
		botBounds = new Rectangle2D.Double(18, 18, worldWidth - 36 + 1E-10,
				worldHeight - 36 + 1E-10);
		myWaves = new LinkedList<Wave>();
		enemyWaves = new LinkedList<Wave>();
	}

	public static void startTurn(OneOnOneBot bot) {
    	time = (int) bot.getTime();
    	Util.addedEnemyWave = null;
    	Util.deletedEnemyWave = null;
    	myP = new Point2D.Double(bot.getX(), bot.getY());
	}

	public static double cannonize(double angle) {
		if (angle < 0) {
			return 2 * Math.PI + angle % (2 * Math.PI);
		}
		return angle % (2 * Math.PI);
	}

	public static double normalize(double angle) {
		return cannonize(angle + Math.PI) - Math.PI;
	}

	public static int cannonize(int angle) {
		if (angle < 0) {
			return (360 + angle % 360) % 360;
		}
		return angle % 360;
	}

	public static int normalize(int angle) {
		return cannonize(angle + 180) - 180;
	}

	public static void log(String message) {
		System.out.println(message);
	}

	public static double bearing(Point2D.Double p1, Point2D.Double p2) {
		return Math.atan2(p2.x - p1.x, p2.y - p1.y);
	}

	public static int bearingDegs(Point2D.Double p1, Point2D.Double p2) {
		return (int) (Math.toDegrees(bearing(p1, p2)) + .5);
	}

	public static Point2D.Double project(Point2D.Double location,
			double distance, int angle) {
		return new Point2D.Double(location.x + distance * sin(angle),
				location.y + distance * cos(angle));
	}

	public static Point2D.Double project(Point2D.Double location,
			double distance, double angle) {
		return new Point2D.Double(location.x + distance * sin(angle),
				location.y + distance * cos(angle));
	}

	public static Point2D.Double project(Bot bot, ScannedRobotEvent scan) {
		return project(new Point2D.Double(bot.getX(), bot.getY()), scan
				.getDistance(), scan.getBearingRadians()
				+ bot.getHeadingRadians());
	}
	
	public static double cos(int angle) {
		return cos[cannonize(angle)];
	}
	
	public static double sin(int angle) {
		return sin[cannonize(angle)];
	}

	public static double cos(double angle) {
		return Math.cos(angle);
		//return cos[cannonize((int) (angle * 180 / Math.PI + .5))];
	}

	public static double sin(double angle) {
		return Math.sin(angle);
		//return sin[cannonize((int) (angle * 180 / Math.PI + .5))];
	}

	public static double asin(double d) {
		return Math.asin(d);
	}

	public static double acos(double d) {
		return Math.acos(d);
	}

	public static boolean equal(double d1, double d2) {
		return Math.abs(d1 - d2) < 1E-10;
	}

	public static boolean equal(Point2D.Double p1, Point2D.Double p2) {
		return Util.equal(p1.x, p2.x) && Util.equal(p1.y, p2.y);
	}

	public static boolean inBound(Point2D.Double p, double margin) {
		// TODO: this should actually move the bot back along the
		// path it travelled
		boolean mod = false;
		double bound = margin;
		if (p.x < bound) {
			p.x = bound;
			mod = true;
		} else {
			bound = worldWidth - margin;
			if (p.x >= bound) {
				p.x = bound - 1E-10;
				mod = true;
			}
		}
		bound = margin;
		if (p.y < bound) {
			p.y = bound;
			mod = true;
		} else {
			bound = worldHeight - margin;
			if (p.y >= bound) {
				p.y = bound - 1E-10;
				mod = true;
			}
		}
		return mod;
	}

	public static double wallDistance(Point2D.Double p, int h, double v) {

		if (v < 0) {
			h += 180;
		}
		h = cannonize(h);
		double distance = Double.POSITIVE_INFINITY;
		if (h < 90 || h > 270) {
			distance = (worldHeight - p.y) / cos[h]; // north
		} else if (h > 90 && h < 270) {
			distance = p.y / -cos[h]; // south
		}
		if (h < 180) {
			double east = (worldWidth - p.x) / sin[h];
			if (east < distance) {
				distance = east;
			}
		} else if (h > 180) {
			double west = p.x / -sin[h];
			if (west < distance) {
				distance = west;
			}
		}
		return distance;
	}

	public static double predictEnergy(Gun gun, int time) {
		double energy = gun.getEnergy();
		double gunHeat = gun.getGunHeat();
		double coolRate = gun.getGunCoolingRate();
		for (int t = (int) gun.getTime(); t < time; ++t) {
			gunHeat -= coolRate;
			if (gunHeat <= 0) {
				energy -= gun.getNextBulletPower();
				gunHeat += getGunHeat(gun.getNextBulletPower());
			}
		}
		if (energy < 0) {
			return 0;
		}
		return energy;
	}

	public static double roll(double oldVal, double newVal, double rollingDepth) {
		return (rollingDepth * oldVal + newVal) / (rollingDepth + 1);
	}
	
	public static double getBulletSpeed(double power) {
		return 20 - 3 * power;
	}
	
	public static double getBulletDamage(double power) {
		if (power > 1) {
			return 6 * power - 2;
		}
		return 4 * power;
	}
	
	public static double getTurnRateRadians(double speed) {
		return (Math.PI / 18) - (Math.PI / 240) * speed;
	}
	
	public static double limit(double value, double min, double max) {
		if (value < min) {
			return min;
		}
		if (value > max) {
			return max;
		}
		return value;
	}
	
	public static int limit(int value, int min, int max) {
		if (value < min) {
			return min;
		}
		if (value > max) {
			return max;
		}
		return value;
	}
	
	public static double getMaxEscape(double bulletSpeed) {
		return asin(8 / bulletSpeed);
	}
	public static double getGunHeat(double power) {
		return 1 + power / 5;
	}
	
	public static int sign(double d) {
		if (d < 0) {
			return -1;
		}
		return 1;
	}
	
	public static void paintLine(Graphics2D g, Point2D.Double p1, Point2D.Double p2) {
		g.drawLine((int) p1.x, (int) p1.y, (int) p2.x, (int) p2.y);
	}

	public static void main(String[] args) {
		System.out.println(Math.ceil(Math.asin(26.0/40) / Math.asin(8.0/11) * 23));
	}
}
