package axeBots.musashi;
import java.awt.geom.*;
import robocode.*;

public class AxeAvoider // extends Condition 
{
    private boolean alert;

    private double botDim;
    private double dimX;
    private double dimY;
    private boolean in;

    private AdvancedRobot myRobot;

    private boolean on= true;
    private RoundRectangle2D.Double rec= null;

    private double x0;
    private double y0;
    private double cornerDiam;

    public AxeAvoider(
        AdvancedRobot ar,
        double x1,
        double y1,
        double x2,
        double y2,
        boolean in) {
        double rw;
        double rh;

        if (ar == null) {
            rw= rh= 40;
        } else {
            rw= ar.getWidth();
            rh= ar.getHeight();
        }

        botDim= Math.max(rw, rh);
        //	esta classe tem como orientacao (0,0) o topo esquerdo,
        // e o campo robocode tem 0,0 baixo esquerdo. para os nossos
        // propositos nao tem problemas.
        cornerDiam= botDim * 3;
        this.rec= new RoundRectangle2D.Double();
        //(x1,y1,(x2-x1),(y2-y1),(botDim*3),(botDim*3));

        this.myRobot= ar;
        this.in= in;

        dimX= x2 - x1; //rec.getWidth();
        dimY= y2 - y1; //rec.getHeight();
        x0= x1; //rec.getX();
        y0= y1; //rec.getY();
        this.reDim(1);
        //this.maxX = this.myRobot.getBattleFieldWidth();
        //this.maxY = this.myRobot.getBattleFieldHeight();
        //this.scanWalls=scanWalls;

        //myRobot.addCustomEvent(this);
        //ar.out.println("new AxeAreaAvoider:("+x1+","+y1+","+x2+","+y2+")");

    }

    //public double   ficalonge() { return ficalonge; }
    //public int   getWalls() { return walls; }

    public RoundRectangle2D.Double getRec() {
        return (RoundRectangle2D.Double)rec.clone();
    }
    /**
     * @return
     */
    public boolean isOn() {
        return on;
    }

    public void reDim(double per) {
        //double dimX = rec.getWidth();
        //double dimY = rec.getHeight();
        double dX= dimX * per;
        double dY= dimY * per;

        double crnDiam;

        double maxDim= Math.min(dX, dY);

        if (maxDim < cornerDiam) {
            crnDiam= maxDim;
        } else {
            crnDiam= cornerDiam;
        }

        rec.setRoundRect(
            x0 - ((dX - dimX) / 2),
            y0 - ((dY - dimY) / 2),
            dX,
            dY,
            crnDiam,
            crnDiam);
    }

    /**
     * @param b
     */
    public void setOn(boolean b) {
        on= b;
    }

    public boolean test() {
        if (!isOn()) {
            return false;
        }
        boolean tst= rec.contains(myRobot.getX(), myRobot.getY());
        alert= !tst ^ in; //xor
        return alert;

    }
    
	public boolean isIn() {
			
			boolean tst= rec.contains(myRobot.getX(), myRobot.getY());
			alert= !tst ^ in; //xor
			return alert;

		}

}
