package tjk.universe;

//import robocode.*;
import tjk.utils.FastTrig;
import java.awt.Graphics2D;
import java.awt.Color;
import java.util.Iterator;
import java.awt.geom.Point2D; // testing close point calcs

/**
 * Painter - a class by tkiesel
 * Copyright (c) 2012 Tom Kiesel (Tkiesel @ Robowiki)
 * 
 * This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
 * 
 *     1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
 *        If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 * 
 *     2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 * 
 *     3. This notice may not be removed or altered from any source distribution.
 * 
 */

public class Painter {
	
	public static boolean PAINT_BOTS = true;
	public static boolean PAINT_V_WAVES = false;
	public static boolean PAINT_WAVES = true;
	public static boolean PAINT_WALL_POINTS = false;
	public static boolean PAINT_MCM = true;
	public static boolean PAINT_BRACKET = true;

	public static void paintBot(Graphics2D g, Bot b, Color c) {
		Color color = g.getColor();
		Color c2 = c;
		g.setColor(c);
		if ( PAINT_BOTS )
		{
			if (b.getEnemy().getFiredShot())
			{
				c = new Color(255,69,0,100);
			}
			g.setColor(c);
			//draw
			int x = (int)b.getEnemy().getX()-18;
			int y = (int)b.getEnemy().getY()-18;
			g.fillRect(x,y,36,36);
			
			if ( PAINT_WALL_POINTS )
			{
				Point2D.Double p = b.closestForwardWallPoint();
				g.setColor(Color.GREEN);
				g.fillRect((int)p.getX()-10,(int)p.getY()-10,20,20);
				p = b.closestBackwardWallPoint();
				g.setColor(Color.RED);
				g.fillRect((int)p.getX()-10,(int)p.getY()-10,20,20);
				p = b.closestLateralWallPoint();
				g.setColor(Color.ORANGE);
				g.fillRect((int)p.getX()-10,(int)p.getY()-10,20,20);
			}
			
			g.setColor(c2);
		}
	
		if ( PAINT_WAVES || PAINT_V_WAVES )
		{
			paintWaves(g,b,c2,b.getWavesIterator());
		}
		
		g.setColor(color);
	}
	
	private static void paintWaves(Graphics2D g, Bot b, Color c, Iterator<Wave> i)
	{	
			while ( i.hasNext() )
			{
				
				Wave w = i.next();
				if ( (w.real && PAINT_WAVES) || (!w.real && PAINT_V_WAVES) )
				{
					if ( w.getState() == Wave.HITTING  )
					{
						g.setColor( new Color(0,0,255,100) );
					}
					else if ( w.getState() == Wave.DEAD  )
					{
						g.setColor( new Color(255,0,255,100) );
					}
					else
					{
						g.setColor(c);
					}	
				
					double r = w.getRadius();
					g.drawOval( (int)(w.getX()-r), (int)(w.getY()-r), (int)(2*r), (int)(2*r) );
				
					if ( PAINT_MCM )
					{
						double[] mcm = w.getMCM();
					
						double x2 = w.getX() + r*FastTrig.sin(mcm[1]);
						double y2 = w.getY() + r*FastTrig.cos(mcm[1]);
						g.drawLine((int)w.getX(),(int)w.getY(),(int)x2,(int)y2);
					
						g.setColor(Color.YELLOW);
						x2 = w.getX() + r*FastTrig.sin(mcm[1]-w.cW()*mcm[0]);
						y2 = w.getY() + r*FastTrig.cos(mcm[1]-w.cW()*mcm[0]);
						g.drawLine((int)w.getX(),(int)w.getY(),(int)x2,(int)y2);
					
						g.setColor(Color.ORANGE);
						x2 = w.getX() + r*FastTrig.sin(mcm[1]+w.cW()*mcm[2]);
						y2 = w.getY() + r*FastTrig.cos(mcm[1]+w.cW()*mcm[2]);
						g.drawLine((int)w.getX(),(int)w.getY(),(int)x2,(int)y2);
					}
			
					if ( PAINT_BRACKET )
					{
						double[] bracket = w.getHitBracket();
					
						if ( bracket[0] != 0.0 || bracket[1] != 0.0 )
						{
							g.setColor(Color.GRAY);
							double angle = w.GFToAbs(bracket[0]);
							double x2 = w.getX() + r*FastTrig.sin(angle);
							double y2 = w.getY() + r*FastTrig.cos(angle);
							g.drawLine((int)w.getX(),(int)w.getY(),(int)x2,(int)y2);
							angle = w.GFToAbs(bracket[1]);
							x2 = w.getX() + r*FastTrig.sin(angle);
							y2 = w.getY() + r*FastTrig.cos(angle);
							g.drawLine((int)w.getX(),(int)w.getY(),(int)x2,(int)y2);
						}
					}
				}
			
			}
	}
	
}