/*
 * Decompiled with CFR 0.152.
 */
package jmcd;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import jmcd.Offset;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Enemy
implements Serializable {
    String Name;
    boolean Alive;
    boolean Seen;
    transient boolean Active;
    double Energy;
    double Distance;
    double Bearing;
    double Heading;
    double Speed;
    long ScanTime;
    double X;
    double Y;
    double AimScore;
    double MoveScore;
    double TurnRate;
    double TR0;
    double TR1;
    double TR2;
    double TR3;
    double AvgVel;
    double V0;
    double V1;
    double V2;
    double V3;
    double Accel;
    double AC0;
    double AC1;
    double AC2;
    double AC3;
    double OldSpeed;
    double OldHeading;
    double OldTime;
    transient Vector OffsetData;
    transient Vector CumAngle;
    transient Vector CumDist;
    transient StringBuffer pattern;
    float[][][][] AimData;
    float[][][] MoveData;

    public void setup() {
        this.Active = true;
        if (this.OffsetData == null) {
            this.OffsetData = new Vector();
        }
        if (this.CumAngle == null) {
            this.CumAngle = new Vector();
        }
        if (this.CumDist == null) {
            this.CumDist = new Vector();
        }
        if (this.pattern == null) {
            this.pattern = new StringBuffer();
        }
    }

    public boolean AvgChange(double TargetSpeed, double TargetHeading, long now) {
        if ((double)now == this.OldTime) {
            return false;
        }
        this.TR3 = this.TR2;
        this.TR2 = this.TR1;
        this.TR1 = this.TR0;
        this.TR0 = this.normalRelativeAngle(TargetHeading - this.OldHeading) / ((double)now - this.OldTime);
        this.TurnRate = (this.TR0 + this.TR1 + this.TR2 + this.TR3) / (double)4;
        this.V3 = this.V2;
        this.V2 = this.V1;
        this.V1 = this.V0;
        this.V0 = TargetSpeed;
        this.AvgVel = (this.V0 + this.V1 + this.V2 + this.V3) / (double)4;
        this.AC3 = this.AC2;
        this.AC2 = this.AC1;
        this.AC1 = this.AC0;
        this.AC0 = (TargetSpeed - this.OldSpeed) / ((double)now - this.OldTime);
        this.Accel = (this.AC0 + this.AC1 + this.AC2 + this.AC3) / (double)4;
        this.OldSpeed = TargetSpeed;
        this.OldHeading = TargetHeading;
        this.OldTime = now;
        return true;
    }

    public void AddOffset(int Melee, int distanceIndex, int fireMethod, float NewAng, float BP) {
        int OSIndexCount = 0;
        int OSTotal = -1;
        int OSOldest = -1;
        Offset NewOff = new Offset(Melee, distanceIndex, fireMethod, NewAng, BP);
        this.OffsetData.add(NewOff);
        Iterator OSeti = this.OffsetData.iterator();
        while (OSeti.hasNext()) {
            Offset OSet = (Offset)OSeti.next();
            if (OSet == null) continue;
            ++OSTotal;
            if (OSet.MIndex != Melee || OSet.DIndex != distanceIndex || OSet.FIndex != fireMethod) continue;
            ++OSIndexCount;
            if (OSOldest != -1) continue;
            OSOldest = OSTotal;
        }
        if (OSIndexCount > 100) {
            this.OffsetData.remove(OSOldest);
            --OSIndexCount;
        }
        this.UpdateAim(Melee, distanceIndex, fireMethod);
    }

    public void UpdateAim(int Melee, int distanceIndex, int fireMethod) {
        float[] OSHist = new float[91];
        int OSIndexCount = 0;
        int besti = 45;
        float bestSum = 0.0f;
        float SumTotal = 0.0f;
        int SpecWidth = 0;
        Iterator OSeti = this.OffsetData.iterator();
        while (OSeti.hasNext()) {
            int OSI;
            Offset OSet = (Offset)OSeti.next();
            if (OSet == null || OSet.MIndex != Melee || OSet.DIndex != distanceIndex || OSet.FIndex != fireMethod) continue;
            int n = OSI = this.OSIndex(OSet.Angle);
            OSHist[n] = OSHist[n] + 1.0f;
            ++OSIndexCount;
        }
        SpecWidth = distanceIndex == 0 ? 10 : (distanceIndex == 1 ? 5 : (distanceIndex == 2 ? 3 : (distanceIndex == 3 ? 2 : (distanceIndex == 4 ? 2 : (distanceIndex == 5 ? 1 : (distanceIndex == 6 ? 1 : 1))))));
        int i = 0;
        while (i <= 90) {
            int endi;
            float ProbSum = 0.0f;
            int starti = i - SpecWidth;
            if (starti < 0) {
                starti = 0;
            }
            if ((endi = i + SpecWidth) > 90) {
                endi = 90;
            }
            SumTotal += OSHist[i];
            int j = starti;
            while (j <= endi) {
                ProbSum += OSHist[j];
                ++j;
            }
            if (ProbSum > bestSum) {
                besti = i;
                bestSum = ProbSum;
            }
            ++i;
        }
        float OSAimProb = SumTotal > 0.0f ? 100.0f * bestSum / SumTotal : 0.0f;
        if (OSIndexCount > 20 || (float)OSIndexCount > this.AimData[Melee][distanceIndex][fireMethod][2]) {
            this.AimData[Melee][distanceIndex][fireMethod][0] = besti - 45;
            this.AimData[Melee][distanceIndex][fireMethod][1] = OSAimProb;
            this.AimData[Melee][distanceIndex][fireMethod][2] = OSIndexCount;
        }
    }

    public int OSIndex(float Offset2) {
        int OSInd = Math.round(Offset2) + 45;
        if (OSInd > 90) {
            OSInd = 90;
        }
        if (OSInd < 0) {
            OSInd = 0;
        }
        return OSInd;
    }

    public float BestOffset(int Melee, int distanceIndex, int fireMethod) {
        return this.AimData[Melee][distanceIndex][fireMethod][0];
    }

    public float AimProb(int Melee, int distanceIndex, int fireMethod) {
        return this.AimData[Melee][distanceIndex][fireMethod][1];
    }

    public void DamGiven(int Melee, int distanceIndex, float Given) {
        float OldGT = this.MoveData[Melee][distanceIndex][0];
        float nGiven = this.MoveData[Melee][distanceIndex][1];
        float AvgGiven = this.MoveData[Melee][distanceIndex][2];
        float nTaken = this.MoveData[Melee][distanceIndex][3];
        float AvgTaken = this.MoveData[Melee][distanceIndex][4];
        float NewGT = 1.0f;
        if (nGiven > 0.0f) {
            NewGT *= 1.0f + Given / (nGiven * AvgGiven);
            AvgGiven = (((nGiven += 1.0f) - 1.0f) * AvgGiven + Given) / nGiven;
        } else if (nTaken > 0.0f) {
            NewGT = Given / (nTaken * AvgTaken);
            nGiven = 1.0f;
            AvgGiven = Given;
        } else {
            NewGT = 1.0f;
            nGiven = 1.0f;
            AvgGiven = Given;
        }
        if (nGiven > 100.0f) {
            nGiven -= 1.0f;
            nTaken -= 1.0f;
        }
        this.MoveData[Melee][distanceIndex][0] = NewGT;
        this.MoveData[Melee][distanceIndex][1] = nGiven;
        this.MoveData[Melee][distanceIndex][2] = AvgGiven;
        this.MoveData[Melee][distanceIndex][3] = nTaken;
    }

    public void DamTaken(int Melee, int distanceIndex, float Taken) {
        float OldGT = this.MoveData[Melee][distanceIndex][0];
        float nGiven = this.MoveData[Melee][distanceIndex][1];
        float AvgGiven = this.MoveData[Melee][distanceIndex][2];
        float nTaken = this.MoveData[Melee][distanceIndex][3];
        float AvgTaken = this.MoveData[Melee][distanceIndex][4];
        float NewGT = 1.0f;
        if (nTaken > 0.0f) {
            NewGT *= 1.0f / (1.0f + Taken / (nTaken * AvgTaken));
            AvgTaken = (((nTaken += 1.0f) - 1.0f) * AvgTaken + Taken) / nTaken;
        } else if (nGiven > 0.0f) {
            NewGT = nGiven * AvgGiven / Taken;
            nTaken = 1.0f;
            AvgTaken = Taken;
        } else {
            NewGT = 0.0f;
            nTaken = 1.0f;
            AvgTaken = Taken;
        }
        if (nTaken > 100.0f) {
            nGiven -= 1.0f;
            nTaken -= 1.0f;
        }
        this.MoveData[Melee][distanceIndex][0] = NewGT;
        this.MoveData[Melee][distanceIndex][1] = nGiven;
        this.MoveData[Melee][distanceIndex][3] = nTaken;
        this.MoveData[Melee][distanceIndex][4] = AvgTaken;
    }

    public int BestDI(int Melee) {
        int BestIndex = 2;
        double BestDist = 0.0;
        int i = 0;
        while (i <= 7) {
            float GT = this.MoveData[Melee][i][0];
            if ((double)GT > BestDist) {
                BestIndex = i;
                BestDist = GT;
            }
            ++i;
        }
        return BestIndex;
    }

    public double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    private final /* synthetic */ void this() {
        this.Alive = false;
        this.Seen = false;
        this.OffsetData = null;
        this.CumAngle = null;
        this.CumDist = null;
        this.pattern = null;
        this.AimData = new float[2][8][4][3];
        this.MoveData = new float[2][8][5];
    }

    Enemy(String Name) {
        this.this();
        this.Name = Name;
    }
}

