/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.utils;

import dmh.robocode.data.Location;
import robocode.util.Utils;

public class Geometry {
    public static Location getLocationAtBearing(Location start, double bearing, double distance) {
        double normalBearing = Utils.normalAbsoluteAngleDegrees((double)bearing);
        double radians = Math.toRadians(normalBearing);
        return new Location(start.getX() + distance * Math.sin(radians), start.getY() + distance * Math.cos(radians));
    }

    public static double getDistanceBetweenLocations(Location start, Location finish) {
        double distanceX = start.getX() - finish.getX();
        double distanceY = start.getY() - finish.getY();
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY);
    }

    public static double getBearingBetweenLocations(Location start, Location finish) {
        double distanceX = finish.getX() - start.getX();
        double distanceY = finish.getY() - start.getY();
        if (distanceY >= 0.0) {
            return Utils.normalAbsoluteAngleDegrees((double)Math.toDegrees(Math.atan(distanceX / distanceY)));
        }
        return Utils.normalAbsoluteAngleDegrees((double)(180.0 + Math.toDegrees(Math.atan(distanceX / distanceY))));
    }

    public static double getRelativeBearing(double currentHeading, double newHeading) {
        double relativeBearing = newHeading - currentHeading;
        if (relativeBearing > 180.0) {
            relativeBearing -= 360.0;
        } else if (relativeBearing < -180.0) {
            relativeBearing += 360.0;
        }
        return relativeBearing;
    }

    public static double getTargetBearingMarginOfError(double distance, double targetSmallestDimension) {
        return Math.toDegrees(Math.atan(targetSmallestDimension / 2.0 / distance));
    }
}

