/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.gun;

import cbot.cbot.Bot;
import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Pray;
import java.util.ArrayList;
import robocode.Bullet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class GunStrategy {
    public static int totHit = 0;
    public static int totFired = 0;
    public static int totHit_short = 0;
    public static int totHit_middle = 0;
    public static int totHit_long = 0;
    public static int totFired_short = 0;
    public static int totFired_middle = 0;
    public static int totFired_long = 0;
    protected CBot robot;
    protected ArrayList bullets;
    protected int allBulletsFired;
    protected int allBulletsHit;
    protected int bulletsFired;
    protected int bulletsHit;

    public void update(CBot robot) {
        this.robot = robot;
    }

    public boolean fire(Pray pray) {
        double firePower = this.getFirePower(pray);
        if (firePower == 0.0) {
            return false;
        }
        Bullet bullet = null;
        while (bullet == null) {
            bullet = this.robot.fireBullet(firePower);
        }
        this.checkBullets();
        ++this.bulletsFired;
        ++totFired;
        double distance = pray.getDistance();
        this.bullets.add(new BulletTracker(bullet, pray.getName(), distance));
        if (distance < CU.DISTANCE_SHORT) {
            ++totFired_short;
        } else if (distance < CU.DISTANCE_MIDDLE) {
            ++totFired_middle;
        } else {
            ++totFired_long;
        }
        return true;
    }

    public void aim(Pray pray) {
        double firePower = this.getFirePower(pray);
        double extraAngle = Math.toDegrees(this.getBulletAngel(this.robot, pray, firePower));
        double turningAngle = CU.normalRelativeAngle(this.getAttackAngle(pray) + extraAngle);
        this.robot.setTurnGunRight(turningAngle);
    }

    protected double getFirePower(Bot pray) {
        return CU.getFirePower(pray);
    }

    public final String getGunHittingRate() {
        return CU.formatNumber(100.0 * ((double)totHit / (double)totFired));
    }

    public String getTotHittingRate() {
        return CU.formatNumber(100.0 * ((double)this.allBulletsHit / (double)this.allBulletsFired));
    }

    public static double[] getDistanceHittingRates() {
        double[] arr = new double[]{100.0 * ((double)totHit_short / (double)totFired_short), 100.0 * ((double)totHit_middle / (double)totFired_middle), 100.0 * ((double)totHit_long / (double)totFired_long)};
        return arr;
    }

    public String getHittingRate() {
        String str = CU.formatNumber(100.0 * ((double)this.bulletsHit / (double)this.bulletsFired));
        this.bulletsFired = 0;
        this.bulletsHit = 0;
        return str;
    }

    protected abstract double getBulletAngel(Bot var1, Bot var2, double var3);

    public abstract boolean match(Bot var1);

    protected abstract String getGunSign();

    protected void updateStatistics() {
        this.allBulletsFired += this.bulletsFired;
        this.allBulletsHit += this.bulletsHit;
    }

    protected void checkBullets() {
        int i = 0;
        while (i < this.bullets.size()) {
            BulletTracker bt = (BulletTracker)this.bullets.get(i);
            if (!bt.bullet.isActive()) {
                if (bt.isHit()) {
                    ++this.bulletsHit;
                    ++totHit;
                    double distance = bt.distance;
                    if (distance < CU.DISTANCE_SHORT) {
                        ++totHit_short;
                    } else if (distance < CU.DISTANCE_MIDDLE) {
                        ++totHit_middle;
                    } else {
                        ++totHit_long;
                    }
                }
                this.bullets.remove(i);
            }
            ++i;
        }
    }

    protected double getAttackAngle(Pray pray) {
        return CU.normalRelativeAngle(this.robot.getHeading() + pray.getBearing() - this.robot.getGunHeading());
    }

    private final /* synthetic */ void this() {
        this.bullets = new ArrayList(5);
        this.allBulletsFired = 0;
        this.allBulletsHit = 0;
        this.bulletsFired = 0;
        this.bulletsHit = 0;
    }

    public GunStrategy(CBot robot) {
        this.this();
        this.robot = robot;
    }

    class BulletTracker {
        public Bullet bullet;
        public String prayName;
        public double distance;

        public boolean isHit() {
            String victim = this.bullet.getVictim();
            if (victim == null) {
                return false;
            }
            return victim.equals(this.prayName);
        }

        public BulletTracker(Bullet b, String s, double d) {
            this.bullet = b;
            this.prayName = s;
            this.distance = d;
        }
    }
}

