/*
 * Decompiled with CFR 0.152.
 */
package simonton.waves;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import robocode.Bullet;
import robocode.ScannedRobotEvent;
import simonton.core.Bot;
import simonton.utils.FastMath;
import simonton.utils.Location;
import simonton.utils.Util;
import simonton.waves.GFProbability;
import simonton.waves.WaveStatistician;
import simonton.waves.WaveStats;

public class Wave {
    public Object firingState;
    public WaveStats stats;
    public Location origin;
    public double angle;
    public double gfOne;
    public double gfNeg;
    public double speed;
    public double firePower;
    public int fireTime;
    public int orientation;
    public int timeTillNext;
    public boolean approaching = true;
    public boolean live = true;
    private WaveStatistician statistician;

    protected Wave() {
    }

    public Wave(Bot bot, ScannedRobotEvent e, int orientation, double firePower, WaveStatistician statistician) {
        this(bot, Util.getAbsoluteBearing(bot, e), orientation, firePower, -10.0, -10.0, statistician);
    }

    public Wave(Bot bot, double angle, int orientation, double firePower, double gfOne, double gfNeg, WaveStatistician statistician) {
        this.statistician = statistician;
        this.orientation = orientation;
        this.angle = angle;
        this.origin = new Location(bot);
        this.fireTime = (int)bot.getTime();
        this.setBulletPower(firePower, gfOne, gfNeg);
    }

    public double getProbability(double gf, double gfBotwidth) {
        return this.stats.getProbability(gf, gfBotwidth);
    }

    public GFProbability getMaximumProbability(double gfBotwidth) {
        return this.stats.getMaximumProbability(gfBotwidth);
    }

    public GFProbability[] getMinimumProbabilities(int numPoints, double gfBotwidth) {
        return this.stats.getMinimumProbabilities(numPoints, gfBotwidth);
    }

    public void setBulletPower(double power, double gfOne, double gfNeg) {
        this.firePower = power;
        this.speed = Util.getBulletSpeed(power);
        this.timeTillNext = FastMath.ceil(Util.getGunHeat(power) / Util.gunCoolingRate);
        if (gfOne == -10.0) {
            this.gfOne = this.gfNeg = Util.getMaxEscape(this.speed);
        } else {
            this.gfOne = gfOne;
            this.gfNeg = gfNeg;
        }
    }

    public void setBulletSpeed(double speed) {
        this.speed = speed;
    }

    public int impactTime(Point2D.Double p) {
        return this.impactTime(this.origin.distance(p));
    }

    public int impactTime(double distance) {
        return this.fireTime + FastMath.ceil(distance / this.speed);
    }

    public boolean willHitBot(double angle, int time, Point2D.Double botLocation) {
        double travel = (double)(time - this.fireTime) * this.speed;
        Location lead = Util.project((Point2D.Double)this.origin, travel, angle);
        Location trail = Util.project((Point2D.Double)this.origin, travel - this.speed, angle);
        return new Rectangle2D.Double(botLocation.x - 18.0, botLocation.y - 18.0, 36.0, 36.0).intersectsLine(lead.x, lead.y, trail.x, trail.y);
    }

    public int washCode(Point2D.Double p, long time) {
        double travel = (double)(time - (long)this.fireTime) * this.speed;
        double toGo = this.origin.distance(p) - travel;
        if (toGo > 26.0) {
            return 1;
        }
        return toGo >= -26.0 - this.speed ? 0 : -1;
    }

    public boolean willPass(Point2D.Double botLocation) {
        double travelNextTick = (double)(Util.time - this.fireTime + 1) * this.speed;
        return travelNextTick >= this.origin.distance(botLocation);
    }

    public int getFactorIndex(double factorAngle, int zeroBin, int binPadding) {
        double offset = (double)this.orientation * FastMath.normalize(factorAngle - this.angle);
        offset = offset > 0.0 ? (offset /= this.gfOne) : (offset /= this.gfNeg);
        return binPadding + (int)((1.0 + offset) * (double)zeroBin + 0.5);
    }

    public int getFactorIndex(Point2D.Double location, int zeroBin, int binPadding) {
        return this.getFactorIndex(Util.bearing(this.origin, location), zeroBin, binPadding);
    }

    public boolean equals(Bullet b) {
        return FastMath.equal(this.speed, b.getVelocity()) && this.washCode(new Location(b), Util.time) == 0;
    }

    public double getAngle(double gf) {
        if (gf >= 0.0) {
            return this.angle + (double)this.orientation * gf * this.gfOne;
        }
        return this.angle + (double)this.orientation * gf * this.gfNeg;
    }

    public double getGf(Point2D.Double p) {
        return this.getGf(Util.bearing(this.origin, p));
    }

    public double getGf(double angle) {
        double offset = (double)this.orientation * FastMath.normalize(angle - this.angle);
        if (offset > 0.0) {
            return offset / this.gfOne;
        }
        return offset / this.gfNeg;
    }

    public double getProbability(Location crashLoc) {
        double gf = this.getGf(Util.bearing(this.origin, crashLoc));
        return this.getProbability(gf, this.getGFBotwidth(gf, crashLoc.distance(this.origin)));
    }

    public double getGFBotwidth(double gf, double distance) {
        double botwidth = 50.0 / distance;
        if (gf > 0.0) {
            return botwidth / this.gfOne;
        }
        return botwidth / this.gfNeg;
    }

    public void setStats(boolean recalc) {
        this.statistician.setStats(this, recalc);
    }

    public void setAimingState() {
        this.statistician.setAimingState(this);
    }

    public void recordDiscovery(double angle) {
        this.statistician.waveDiscovered(this, this.getGf(angle));
    }

    public void recordPassing(Point2D.Double hisLoc) {
        this.statistician.wavePassed(this, this.getGf(hisLoc));
    }

    public void updateStats() {
        this.statistician.updateStats(this);
    }

    public double getMaximumProbabilityAngle(double distance) {
        return this.stats.getMaximumProbability((double)this.getGFBotwidth((double)1.0, (double)distance)).angle;
    }

    public void paintTickmark(Graphics2D g, double angle) {
        this.paintTickmark(g, angle, this.speed);
    }

    public void paintTickmark(Graphics2D g, double angle, double tickLength) {
        int r = (int)(this.speed * (double)(Util.time - this.fireTime));
        Location lead = Util.project((Point2D.Double)this.origin, (double)r, angle);
        Location trail = Util.project((Point2D.Double)this.origin, (double)r - tickLength, angle);
        Util.paintLine(g, (Point2D.Double)lead, trail);
    }

    public void onPaint(Graphics2D g, int time) {
        g.setColor(Color.BLUE);
        int r = (int)(this.speed * (double)(time - this.fireTime));
        if (r < 0) {
            g.setColor(Color.RED);
            r = -r;
        }
        Util.paintCircle(g, this.origin, 2 * r, false);
        this.paintTickmark(g, this.getAngle(1.0), 40.0);
        Location lead = Util.project((Point2D.Double)this.origin, (double)r, this.angle);
        Location trail = Util.project((Point2D.Double)this.origin, (double)r - this.speed, this.angle);
        Util.paintLine(g, (Point2D.Double)lead, trail);
        this.stats.onPaint(g, time);
    }

    public static class TimeToImpactComparator
    implements Comparator {
        private Point2D.Double impactPoint;

        public int compare(Wave w1, Wave w2) {
            return w1.impactTime(this.impactPoint) - w2.impactTime(this.impactPoint);
        }

        public int compare(Object obj, Object obj1) {
            return this.compare((Wave)obj, (Wave)obj1);
        }

        public TimeToImpactComparator(Point2D.Double impactPoint) {
            this.impactPoint = impactPoint;
        }
    }
}

