/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.EnemyRobot;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import robocode.ScannedRobotEvent;

public class EnemyRobotList {
    private List<EnemyRobot> target_list = new LinkedList<EnemyRobot>();

    public void update(ScannedRobotEvent enemy, double angle, Point2D position) {
        EnemyRobot tmp = this.getRobot(enemy.getName());
        if (tmp == null) {
            this.addTarget(enemy, angle, position);
        } else {
            tmp.update(enemy, angle, position);
        }
    }

    private void addTarget(ScannedRobotEvent enemy, double angle, Point2D position) {
        this.target_list.add(new EnemyRobot(enemy, angle, position));
        Collections.sort(this.target_list);
    }

    public void remove(String name) {
        int tmp = this.getIndex(name);
        if (tmp < 0) {
            return;
        }
        this.target_list.remove(tmp);
        Collections.sort(this.target_list);
    }

    public void updateEnergy(String name, double energy) {
        EnemyRobot tmp = this.getRobot(name);
        if (tmp == null) {
            return;
        }
        tmp.setEnergy(energy);
    }

    public EnemyRobot getRobot(String name) {
        int tmp = this.getIndex(name);
        if (tmp < 0) {
            return null;
        }
        return this.getRobot(tmp);
    }

    public EnemyRobot getRobot(int index) {
        return this.target_list.get(index);
    }

    public int getNumber() {
        return this.target_list.size();
    }

    private int getIndex(String name) {
        return Collections.binarySearch(this.target_list, new EnemyRobot(name));
    }
}

