/*
 * Decompiled with CFR 0.152.
 */
package ry;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import ry.Enemy;
import ry.Gun;
import ry.HeadOnGun;
import ry.LightningMover;
import ry.MinimumRisk;
import ry.PatternMatcherGun;
import ry.PredictiveGun;
import ry.ReallyBadGun;
import ry.SGFTGun;
import ry.VBulletWave;
import utils.Utils;

public class VirtualGunExperiment
extends AdvancedRobot {
    static final double BULLET_POWER = 3.0;
    static final double MID_BULLET_POWER = 1.9;
    static final double MIN_BULLET_POWER = 1.5;
    static Hashtable enemies = new Hashtable();
    Enemy enemy;
    static AdvancedRobot shooter;
    static ArrayList<Gun> guns;
    static ArrayList<VBulletWave> virtualBullets;
    Rectangle2D.Double battlefield;
    static Gun defaultGun;
    private static LightningMover kmovement;
    private static MinimumRisk rmovement;
    double bulletPower;
    String[] quoteDatabase = new String[]{"Wars teach us not to love our enemies, but to hate our allies", "A thing is not necesssarily true because a man dies for it", "In war, there are no unwounded soldiers", "For what can war, but endless war, still breed?", "O peace! how many wars are waged in thy name.", "War remains the decisive human failure", "The sinews of war are infinite money", "War doesn't make boys men, it makes men dead", "Politics is the womb in which war develops", "All warfare is based on deception", "One more victory and we are undone", "Force is all-conquering, but its victories are short-lived", "In the eyes of empire builders men are not men but instruments", "Never do an enemy a small injury", "Wars are not paid for in wartime, the bill comes later", "We make war that we may live in peace.", "The supreme excellence is to subdue the armies of your enemies without even having to fight them", "Nations, like individuals, are punished for their transgressions"};

    static {
        virtualBullets = new ArrayList();
    }

    public VirtualGunExperiment() {
        kmovement = new LightningMover(this);
        rmovement = new MinimumRisk(this);
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.battlefield = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.enemy = new Enemy();
        if (guns == null) {
            guns = new ArrayList();
            defaultGun = new PredictiveGun();
            guns.add(defaultGun);
            guns.add(new ReallyBadGun());
            guns.add(new HeadOnGun());
            guns.add(new PatternMatcherGun());
            guns.add(new SGFTGun());
        }
        virtualBullets.clear();
        if (this.getOthers() < 3) {
            while (true) {
                this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
        }
        rmovement.run();
    }

    public void doGun() {
        Bullet b;
        long bestScore = -1L;
        Gun bestGun = defaultGun;
        for (Gun gun : guns) {
            if (gun.hits <= bestScore) continue;
            bestScore = gun.hits;
            bestGun = gun;
        }
        if (this.getOthers() < 3) {
            if (Math.abs(this.enemy.energy - this.getEnergy()) > 10.0) {
                this.bulletPower = this.enemy.distance > 200.0 ? 1.5 : 3.0;
            } else {
                double d = this.bulletPower = this.enemy.distance > 200.0 ? 1.5 : 3.0;
            }
            if (this.enemy.energy < Utils.DamageDealt(this.bulletPower) - 10.0) {
                this.bulletPower = this.enemy.energy / 4.0;
            }
        } else {
            this.bulletPower = 3.0;
        }
        this.setTurnGunRightRadians(Utils.normalizeBearing(bestGun.getFiringAngle(this, this.enemy, this.bulletPower) - this.getGunHeadingRadians()));
        if (this.getGunHeat() == 0.0 && this.getGunTurnRemaining() < 5.0 && (b = this.setFireBullet(this.bulletPower)) != null) {
            for (Gun gun : guns) {
                VBulletWave newVirtualBullet = new VBulletWave();
                newVirtualBullet.currentLocation = newVirtualBullet.firedLocation = new Point2D.Double(this.getX(), this.getY());
                newVirtualBullet.bearing = gun.getFiringAngle(this, this.enemy, b.getPower());
                newVirtualBullet.velocity = Utils.bulletVelocity(b.getPower());
                newVirtualBullet.gunUsed = gun;
                newVirtualBullet.shooter = this;
                virtualBullets.add(newVirtualBullet);
                this.addCustomEvent(newVirtualBullet);
                if (!(gun instanceof SGFTGun)) continue;
                SGFTGun cfr_ignored_0 = (SGFTGun)gun;
                SGFTGun.w.firing = true;
                SGFTGun cfr_ignored_1 = (SGFTGun)gun;
                this.addCustomEvent(SGFTGun.w);
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en = (Enemy)enemies.get(e.getName());
        if (en == null) {
            en = new Enemy();
            enemies.put(e.getName(), en);
        }
        if (this.getOthers() == 1) {
            this.setTurnRadarRightRadians(Utils.normalizeBearing(e.getBearingRadians() + this.getHeadingRadians() - this.getRadarHeadingRadians()) * 1.89);
        }
        if (this.getOthers() < 3) {
            kmovement.onScannedRobot(e);
        } else {
            rmovement.onScannedRobot(e);
        }
        en.pEnergy = en.energy;
        en.pHeading = en.heading;
        en.velocity = en.velocity;
        en.pX = en.x;
        en.pY = en.y;
        en.lastUpdated = e.getTime();
        en.bearing = e.getBearingRadians();
        en.distance = e.getDistance();
        en.energy = e.getEnergy();
        en.heading = e.getHeadingRadians();
        en.velocity = e.getVelocity();
        en.name = e.getName();
        double absBearing = this.getHeadingRadians() + e.getBearingRadians();
        en.x = this.getX() + Math.sin(absBearing) * e.getDistance();
        en.y = this.getY() + Math.cos(absBearing) * e.getDistance();
        if (!this.enemy.live || e.getDistance() < Math.sqrt((this.getX() - this.enemy.x) * (this.getX() - this.enemy.x) + (this.getY() - this.enemy.y) * (this.getY() - this.enemy.y))) {
            this.enemy = en;
        }
        this.doGun();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.getOthers() < 3) {
            kmovement.onHitByBullet(e);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.getOthers() >= 3) {
            rmovement.onRobotDeath(e);
        }
        ((Enemy)VirtualGunExperiment.enemies.get((Object)e.getName())).live = false;
        this.setTurnRadarRightRadians(Math.PI * 2);
    }

    public void onDeath(DeathEvent e) {
        this.endRound();
    }

    public void onWin(WinEvent e) {
        this.endRound();
    }

    public void endRound() {
        int i = virtualBullets.size() - 1;
        while (i >= 0) {
            this.removeCustomEvent(virtualBullets.get(i));
            virtualBullets.remove(i);
            --i;
        }
        this.out.println();
        this.out.println("Virtual bullet hit table");
        this.out.println("------------------------");
        for (Gun gun : guns) {
            String percent = String.valueOf(gun.fired() == 0L ? 0.0 : (double)gun.hits / (double)gun.fired() * 100.0) + "%";
            this.out.println(String.valueOf(gun.getName()) + ": " + percent);
        }
        this.out.println();
        this.out.println(this.quoteDatabase[(int)(Math.random() * (double)this.quoteDatabase.length)]);
        this.enemy = new Enemy();
    }

    public void onMousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            Random r = new Random();
            this.setColors(new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256)), new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256)), new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256)));
            this.out.println(this.enemy.name);
        }
    }

    public void onPaint(Graphics2D g) {
        for (VBulletWave virtualBullet : virtualBullets) {
            g.setColor(virtualBullet.gunUsed.getColor());
            double bulletSize = (virtualBullet.velocity - 20.0) / -3.0;
            g.fillOval((int)(virtualBullet.currentLocation.x - bulletSize), (int)(virtualBullet.currentLocation.y - bulletSize), (int)(bulletSize * 2.0), (int)(bulletSize * 2.0));
        }
        int numberOfGuns = guns.size();
        int j = 0;
        while (j < numberOfGuns) {
            Gun gun = guns.get(numberOfGuns - 1 - j);
            g.setColor(Color.WHITE);
            String percent = String.valueOf(gun.fired() == 0L ? 0.0 : (double)Math.round((double)gun.hits / (double)gun.fired() * 1000.0) / 10.0) + "%";
            g.drawString(String.valueOf(gun.getName()) + ": " + percent, 20, 5 + j * 15);
            g.setColor(gun.getColor());
            g.fillOval(5, 3 + j * 15, 10, 10);
            ++j;
        }
    }
}

