/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.wave;

import java.awt.Color;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.wave.RWave;
import robocode.util.Utils;

public class REnemyWave
extends RWave {
    public static final Color DEFAULT_COLOR = Color.red;
    protected REnemyRobot creator;
    protected RRobotState creatorState;
    protected RRobotState targetState;
    protected double directionAngle;
    protected int direction;
    protected long estimatedFlightTime;

    public REnemyWave(REnemyRobot creator) {
        this(creator, creator.getCurrentState().location.getCopy(), creator.getReference().getTime(), creator.getShotPower() > 0.0 ? creator.getShotPower() : 3.0);
    }

    public REnemyWave(REnemyRobot creator, RPoint origin, long timeFired, double power) {
        super(origin, timeFired - 1L, power, DEFAULT_COLOR);
        this.creator = creator;
        this.creatorState = creator.getCurrentState().getCopy();
        this.targetState = creator.getReference().getLastUsableState();
        this.directionAngle = creator.getLastUsableBearing();
        this.direction = creator.getLastUsableSurfDirection();
        this.estimatedFlightTime = (long)(this.creatorState.distance / this.velocity);
    }

    public boolean didBreak(RPoint point) {
        return this.distanceTraveled > point.distance(this.origin) + 50.0;
    }

    public boolean intercepted(RPoint point, int time) {
        return point.distance(this.getOrigin()) < this.getDistanceTraveled() + (double)time * this.getVelocity() + this.getVelocity();
    }

    public double computeOffsetAngle(RPoint target) {
        return RUtil.computeAbsoluteBearing(this.getOrigin(), target) - this.getDirectionAngle();
    }

    public double computeRawFactor(RPoint hitLocation) {
        double offset = this.computeOffsetAngle(hitLocation);
        return Utils.normalRelativeAngle((double)offset) / RUtil.computeMaxEscapeAngle(this.getVelocity()) * (double)this.getDirection();
    }

    public double getDirectionAngle() {
        return this.directionAngle;
    }

    public int getDirection() {
        return this.direction;
    }

    public double getEstimatedFlightTime() {
        return this.estimatedFlightTime;
    }

    public REnemyRobot getCreator() {
        return this.creator;
    }

    public RRobotState getCreatorState() {
        return this.creatorState;
    }

    public RRobotState getTargetState() {
        return this.targetState;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.creatorState == null ? 0 : this.creatorState.hashCode());
        result = 31 * result + this.direction;
        long temp = Double.doubleToLongBits(this.directionAngle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.estimatedFlightTime ^ this.estimatedFlightTime >>> 32);
        result = 31 * result + (this.targetState == null ? 0 : this.targetState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        REnemyWave other = (REnemyWave)obj;
        if (this.creatorState == null ? other.creatorState != null : !this.creatorState.equals(other.creatorState)) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        if (Double.doubleToLongBits(this.directionAngle) != Double.doubleToLongBits(other.directionAngle)) {
            return false;
        }
        if (this.estimatedFlightTime != other.estimatedFlightTime) {
            return false;
        }
        return !(this.targetState == null ? other.targetState != null : !this.targetState.equals(other.targetState));
    }
}

