/*
 * Decompiled with CFR 0.152.
 */
package ender;

import ender.GameStatus;
import ender.ScanStatus;
import ender.Wave;
import java.awt.geom.Point2D;

public class MovePredictor {
    private static MovePredictor _instance = null;
    private static final int TIME_MAX = 3;
    private static final int TIME_MIN = 0;
    private static final int TIME_STEP = 1;
    private static final int TANK_SPEED_MIN = -8;
    private static final int TANK_SPEED_MAX = 8;
    private static final int SPEED_STEP = 1;
    private static final int HEADING_MAX = 360;
    private static final int HEADING_MIN = 0;
    private static final int HEADING_STEP = 10;
    private double[][][] mDatabase = new double[3][36][17];

    public static MovePredictor instance() {
        if (_instance == null) {
            _instance = new MovePredictor();
        }
        return _instance;
    }

    protected MovePredictor() {
    }

    public void updateHit(Wave wave, long endtime, double heading, double velocity) {
        int delta = Math.min((int)(endtime - wave.getTime()), 2);
        int headingCategory = this.getHeadingCategory(heading);
        int tankSpeedCategory = this.getSpeedCategory(velocity);
        double[] dArray = this.mDatabase[0][headingCategory];
        int n = tankSpeedCategory;
        dArray[n] = dArray[n] * 2.0;
        double value = this.mDatabase[0][headingCategory][tankSpeedCategory];
        int i = 1;
        while (i <= delta) {
            ScanStatus status = GameStatus.instance().get((long)i + wave.getTime());
            if (status != null) {
                headingCategory = this.getHeadingCategory(Math.atan2(status.getLocation((int)0).x - wave.getCenter().x, status.getLocation((int)0).y - wave.getCenter().x));
                tankSpeedCategory = this.getSpeedCategory(status.getAttr(8));
                this.mDatabase[i][headingCategory][tankSpeedCategory] = Math.min(this.mDatabase[i][headingCategory][tankSpeedCategory], value);
                value = this.mDatabase[i][headingCategory][tankSpeedCategory];
            }
            ++i;
        }
        System.out.println("Actualizando [" + delta + "][" + headingCategory + "][" + tankSpeedCategory + "]: " + this.mDatabase[delta][headingCategory][tankSpeedCategory]);
    }

    public void updateNoHit(Wave wave, long endtime, double heading, double velocity) {
        int delta = Math.min((int)(endtime - wave.getTime()), 2);
        int headingCategory = this.getHeadingCategory(heading);
        int tankSpeedCategory = this.getSpeedCategory(velocity);
        double[] dArray = this.mDatabase[0][headingCategory];
        int n = tankSpeedCategory;
        double d = dArray[n] - 1.0;
        dArray[n] = d;
        double value = d;
        int i = 1;
        while (i <= delta) {
            ScanStatus status = GameStatus.instance().get((long)i + wave.getTime());
            if (status != null) {
                headingCategory = this.getHeadingCategory(Math.atan2(status.getLocation((int)0).x - wave.getCenter().x, status.getLocation((int)0).y - wave.getCenter().x));
                tankSpeedCategory = this.getSpeedCategory(status.getAttr(8));
                this.mDatabase[i][headingCategory][tankSpeedCategory] = Math.min(this.mDatabase[i][headingCategory][tankSpeedCategory], value);
                value = this.mDatabase[i][headingCategory][tankSpeedCategory];
            }
            ++i;
        }
        System.out.println("Actualizando [" + delta + "][" + headingCategory + "][" + tankSpeedCategory + "]: " + this.mDatabase[delta][headingCategory][tankSpeedCategory]);
    }

    public double getPrediction(Wave wave, Point2D.Double position, double speed, double heading, long tick) {
        int tickstohit = Math.min((int)((position.distance(wave.getCenter()) - wave.getDistanceByTick(tick - wave.getTime()) - 20.0) / wave.getSpeed()), 2);
        int headingCategory = this.getHeadingCategory(Math.atan2(position.x - wave.getCenter().x, position.y - wave.getCenter().x));
        int speedCategory = this.getSpeedCategory(speed);
        if (tickstohit < 0 || headingCategory < 0 || speedCategory < 0) {
            return -1.0;
        }
        System.out.println("Consultando [" + tickstohit + "][" + headingCategory + "][" + speedCategory + "]");
        return this.mDatabase[tickstohit][headingCategory][speedCategory];
    }

    private int getSpeedCategory(double speed) {
        if (speed == 0.0) {
            return 1;
        }
        return (int)Math.signum(speed) + 1;
    }

    private int getHeadingCategory(double heading) {
        return (int)(Math.abs(heading) * 180.0 / Math.PI / 10.0);
    }
}

