/*
 * Decompiled with CFR 0.152.
 */
package apv;

import apv.MovSimStat;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class MovSim {
    private static double systemMaxTurnRate = Math.toRadians(10.0);
    private static double systemMaxVelocity = 8.0;
    private static double maxBraking = 2.0;
    private static double maxAcceleration = 1.0;
    public static double defaultMaxTurnRate = Math.toRadians(10.0);
    public static double defaultMaxVelocity = 8.0;

    public static MovSimStat[] futurePos(int steps, AdvancedRobot b) {
        return MovSim.futurePos(steps, b, defaultMaxVelocity, defaultMaxTurnRate);
    }

    public static MovSimStat[] futurePos(int steps, AdvancedRobot b, double maxVel, double maxTurnRate) {
        return MovSim.futurePos(steps, b.getX(), b.getY(), b.getVelocity(), maxVel, b.getHeadingRadians(), b.getDistanceRemaining(), b.getTurnRemainingRadians(), maxTurnRate, b.getBattleFieldWidth(), b.getBattleFieldHeight());
    }

    public static MovSimStat[] futurePos(int steps, double x, double y, double velocity, double maxVelocity, double heading, double distanceRemaining, double angleToTurn, double maxTurnRate, double battleFieldW, double battleFieldH) {
        MovSimStat[] pos = new MovSimStat[steps];
        double acceleration = 0.0;
        boolean slowingDown = false;
        double moveDirection = distanceRemaining == 0.0 ? 0.0 : (distanceRemaining < 0.0 ? (double)-1 : 1.0);
        int i = 0;
        while (i < steps) {
            double lastHeading = heading;
            double turnRate = Math.min(maxTurnRate, (0.4 + 0.6 * (1.0 - Math.abs(velocity) / systemMaxVelocity)) * systemMaxTurnRate);
            if (angleToTurn > 0.0) {
                if (angleToTurn < turnRate) {
                    heading += angleToTurn;
                    angleToTurn = 0.0;
                } else {
                    heading += turnRate;
                    angleToTurn -= turnRate;
                }
            } else if (angleToTurn < 0.0) {
                if (angleToTurn > -turnRate) {
                    heading += angleToTurn;
                    angleToTurn = 0.0;
                } else {
                    heading -= turnRate;
                    angleToTurn += turnRate;
                }
            }
            heading = Utils.normalAbsoluteAngle((double)heading);
            if (distanceRemaining != 0.0 || velocity != 0.0) {
                if (!slowingDown && moveDirection == 0.0) {
                    slowingDown = true;
                    moveDirection = velocity > 0.0 ? 1.0 : (velocity < 0.0 ? (double)-1 : 0.0);
                }
                double desiredDistanceRemaining = distanceRemaining;
                if (slowingDown) {
                    if (moveDirection == 1.0 && distanceRemaining < 0.0) {
                        desiredDistanceRemaining = 0.0;
                    } else if (moveDirection == (double)-1 && distanceRemaining > 1.0) {
                        desiredDistanceRemaining = 0.0;
                    }
                }
                double slowDownVelocity = (int)(maxBraking / 2.0 * (Math.sqrt(4.0 * Math.abs(desiredDistanceRemaining) + 1.0) - 1.0));
                if (moveDirection == (double)-1) {
                    slowDownVelocity = -slowDownVelocity;
                }
                if (!slowingDown) {
                    if (moveDirection == 1.0) {
                        acceleration = velocity < 0.0 ? maxBraking : maxAcceleration;
                        if (velocity + acceleration > slowDownVelocity) {
                            slowingDown = true;
                        }
                    } else if (moveDirection == (double)-1 && velocity + (acceleration = velocity > 0.0 ? -maxBraking : -maxAcceleration) < slowDownVelocity) {
                        slowingDown = true;
                    }
                }
                if (slowingDown) {
                    double perfectAccel;
                    if (distanceRemaining != 0.0 && Math.abs(velocity) <= maxBraking && Math.abs(distanceRemaining) <= maxBraking) {
                        slowDownVelocity = distanceRemaining;
                    }
                    if ((perfectAccel = slowDownVelocity - velocity) > maxBraking) {
                        perfectAccel = maxBraking;
                    } else if (perfectAccel < -maxBraking) {
                        perfectAccel = -maxBraking;
                    }
                    acceleration = perfectAccel;
                }
                if (!(velocity <= maxVelocity) || velocity < -maxVelocity) {
                    acceleration = 0.0;
                }
                if ((velocity += acceleration) > maxVelocity) {
                    velocity -= Math.min(maxBraking, velocity - maxVelocity);
                }
                if (velocity < -maxVelocity) {
                    velocity += Math.min(maxBraking, -velocity - maxVelocity);
                }
                double dx = velocity * Math.sin(heading);
                double dy = velocity * Math.cos(heading);
                x += dx;
                y += dy;
                if (slowingDown && velocity == 0.0) {
                    distanceRemaining = 0.0;
                    moveDirection = 0.0;
                    slowingDown = false;
                    acceleration = 0.0;
                }
                distanceRemaining -= velocity;
                if (!(x >= (double)18) || !(y >= (double)18) || !(x <= battleFieldW - (double)18) || y > battleFieldH - (double)18) {
                    distanceRemaining = 0.0;
                    angleToTurn = 0.0;
                    velocity = 0.0;
                    moveDirection = 0.0;
                    x = Math.max((double)18, Math.min(battleFieldW - (double)18, x));
                    y = Math.max((double)18, Math.min(battleFieldH - (double)18, y));
                }
            }
            pos[i] = new MovSimStat(x, y, velocity, heading, Utils.normalRelativeAngle((double)(heading - lastHeading)));
            ++i;
        }
        return pos;
    }
}

