/*
 * Decompiled with CFR 0.152.
 */
package krillr.mini;

import java.awt.geom.RoundRectangle2D;
import krillr.mini.BT;
import krillr.mini.UI;
import krillr.mini.UT;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class JointStrike
extends TeamRobot {
    static double _direction = 1.0;
    static final double FOUR_QUARTERS = Math.PI * 2;
    static final double ONE_QUARTER = 1.5707963267948966;
    static final double ONE_EIGHTH = 0.7853981633974483;
    static final double ONE_QUARTER_PLUS_DEGREE = 1.5882463267948965;
    public BT bt = new BT(this);
    UT target = new UT();
    int timeToGetNewTarget = 0;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            if (this.timeToGetNewTarget == 0 | this.target.newUT) {
                this.target = this.bt.getClosest();
                this.timeToGetNewTarget = 5;
            }
            if (!this.target.newUT) {
                this.shootTarget();
                this.moveIt();
            }
            this.execute();
            --this.timeToGetNewTarget;
            this.out.println("My X: " + this.getX());
            this.out.println("My Y: " + this.getY());
        }
    }

    public void shootTarget() {
        double angle = this.target.p.getBearing();
        this.setTurnGunRightRadians(angle);
        this.setFire(3.0);
    }

    public void moveIt() {
        RoundRectangle2D.Double _battlefield = new RoundRectangle2D.Double(35.0, 35.0, this.getBattleFieldWidth() - 70.0, this.getBattleFieldHeight() - 70.0, 100.0, 100.0);
        double nextX = 0.0;
        double nextY = 0.0;
        UI info = this.target.lastInfo();
        double distance = info.distance;
        double x = this.getX();
        double y = this.getY();
        double enemyHeading = this.getHeadingRadians() + info.bearing;
        double eX = Math.sin(enemyHeading) * distance + x;
        double eY = Math.cos(enemyHeading) * distance + y;
        if (Math.random() < 0.085) {
            _direction = -_direction;
        }
        for (int i = 0; i < 2; ++i) {
            double r;
            double a = 1.5882463267948965 + (1.5707963267948966 / (1.0 + Math.exp((distance - 400.0) / 100.0)) - 0.7853981633974483);
            while (!_battlefield.contains(nextX = x + Math.sin(r = enemyHeading + (a -= 0.01745) * _direction) * 65.0, nextY = y + Math.cos(r) * 65.0) && a > 0.7853981633974483) {
            }
            if (_battlefield.contains(nextX, nextY)) break;
            _direction = -_direction;
        }
        nextX = Utils.normalRelativeAngle((double)(Math.atan2(nextX - x, nextY - y) - this.getHeadingRadians()));
        nextY = 65.0;
        if (Math.abs(nextX) > 1.5707963267948966) {
            nextY = -nextY;
            nextX += nextX > 0.0 ? -Math.PI : Math.PI;
        }
        this.setTurnRightRadians(nextX);
        this.setAhead(nextY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.bt.addUnit(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.bt.removeUnit(e.getName());
        this.target = this.bt.getClosest();
        this.timeToGetNewTarget = 10;
    }
}

