/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.WeightUpdater;
import dmonner.xlbp.connection.Connection;

public class DecayWeightUpdater
implements WeightUpdater {
    public static final long serialVersionUID = 1L;
    private final Connection parent;
    private final float a;
    private final float b;

    public DecayWeightUpdater(Connection parent) {
        this(parent, 0.1f, 0.001f);
    }

    public DecayWeightUpdater(Connection parent, float a, float b) {
        this.parent = parent;
        this.a = a;
        this.b = b;
    }

    @Override
    public Connection getConnection() {
        return this.parent;
    }

    @Override
    public float getUpdate(int j, float dw) {
        return this.a * dw - this.b * this.parent.getWeight(j, 0);
    }

    @Override
    public float getUpdate(int j, int i, float dw) {
        return this.a * dw - this.b * this.parent.getWeight(j, i);
    }

    @Override
    public void initialize(int size) {
    }

    @Override
    public void initialize(int to, int from) {
    }

    @Override
    public void processBatch() {
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showLearningRates()) {
            sb.appendln("Learning Rate:" + this.a);
            sb.appendln("Weight Decay Rate:" + this.b);
        }
    }

    @Override
    public void updateFromBiases(float[] d) {
    }

    @Override
    public void updateFromEligibilities(float[][] e, float[] d) {
    }

    @Override
    public void updateFromInputs(float[] in, float[] d) {
    }

    @Override
    public void updateFromVector(float[] v, float[] d) {
    }
}

