/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.layer.Layer;
import dmonner.xlbp.util.MatrixTools;
import java.util.Arrays;

public abstract class AbstractLayer
implements Layer {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected final int size;
    protected float[] y;
    protected Responsibilities d;
    protected boolean built;

    public AbstractLayer(AbstractLayer that, NetworkCopier copier) {
        this.name = copier.getCopyNameFrom(that);
        this.size = that.size;
        if (that.y != null) {
            float[] fArray = this.y = copier.copyState() ? MatrixTools.copy(that.y) : MatrixTools.empty(that.y);
        }
        if (that.d != null) {
            this.d = copier.copyState() ? that.d.copy() : new Responsibilities(that.d.size());
        }
    }

    public AbstractLayer(String name, int size) {
        this.name = name;
        this.size = size;
    }

    @Override
    public void aliasResponsibilities(int index, Responsibilities resp) {
        this.d = resp;
    }

    @Override
    public void clear() {
        this.clearActivations();
        this.clearEligibilities();
        this.clearResponsibilities();
    }

    @Override
    public void clearActivations() {
        Arrays.fill(this.y, 0.0f);
    }

    @Override
    public void clearEligibilities() {
    }

    @Override
    public void clearResponsibilities() {
        this.d.clear();
    }

    @Override
    public int compareTo(Component that) {
        return this.name.compareTo(that.getName());
    }

    @Override
    public abstract AbstractLayer copy(NetworkCopier var1);

    @Override
    public AbstractLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component that, NetworkCopier copier) {
    }

    @Override
    public float[] getActivations() {
        return this.y;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Responsibilities getResponsibilities() {
        return this.d;
    }

    @Override
    public Responsibilities getResponsibilities(int index) {
        return this.d;
    }

    @Override
    public boolean isBuilt() {
        return this.built;
    }

    @Override
    public int nWeights() {
        return 0;
    }

    @Override
    public void processBatch() {
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
    }

    @Override
    public void setWeightUpdaterType(WeightUpdaterType wut) {
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showName()) {
            sb.indent();
            sb.append(this.name);
            sb.append(" (");
            sb.append(String.valueOf(this.size()));
            sb.append(")");
            sb.append(" : ");
            sb.append(this.getClass().getSimpleName());
            sb.appendln();
        }
        sb.pushIndent();
        if (sb.showActivations()) {
            sb.appendln("Activations:");
            sb.pushIndent();
            sb.appendln(MatrixTools.toString(this.y));
            sb.popIndent();
        }
        if (sb.showResponsibilities()) {
            sb.appendln("Responsibilities:");
            sb.pushIndent();
            sb.appendln(this.d.toString());
            sb.popIndent();
        }
        sb.popIndent();
    }

    @Override
    public String toString(String show) {
        NetworkStringBuilder sb = new NetworkStringBuilder(show);
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public void unbuild() {
        this.built = false;
    }

    @Override
    public void updateWeights() {
    }
}

