/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Random;

public class MatrixTools {
    public static DecimalFormat floatFormat = new DecimalFormat("0.0000");
    public static String floatWidth = "%8s";

    public static int argmin(int[] a) {
        int arg = 0;
        for (int i = 1; i < a.length; ++i) {
            if (a[i] >= a[arg]) continue;
            arg = i;
        }
        return arg;
    }

    public static float[] copy(float[] source) {
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public static float[][] copy(float[][] source) {
        if (source == null) {
            return null;
        }
        float[][] dest = new float[source.length][];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = MatrixTools.copy(source[i]);
        }
        return dest;
    }

    public static int[] copy(int[] source) {
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public static int[][] copy(int[][] source) {
        if (source == null) {
            return null;
        }
        int[][] dest = new int[source.length][];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = MatrixTools.copy(source[i]);
        }
        return dest;
    }

    public static float distance(float[] a, float[] b) {
        return (float)Math.sqrt(MatrixTools.distanceSq(a, b));
    }

    public static float distanceSq(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Vectors must be of the same length: " + a.length + " != " + b.length);
        }
        float dist = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            dist += (b[i] - a[i]) * (b[i] - a[i]);
        }
        return dist;
    }

    public static float[] empty(float[] source) {
        if (source == null) {
            return null;
        }
        return new float[source.length];
    }

    public static float[][] empty(float[][] source) {
        if (source == null) {
            return null;
        }
        float[][] dest = new float[source.length][];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = MatrixTools.empty(source[i]);
        }
        return dest;
    }

    public static int[] empty(int[] source) {
        if (source == null) {
            return null;
        }
        return new int[source.length];
    }

    public static int[][] empty(int[][] source) {
        if (source == null) {
            return null;
        }
        int[][] dest = new int[source.length][];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = MatrixTools.empty(source[i]);
        }
        return dest;
    }

    public static float[][] identity(int n) {
        float[][] f = new float[n][n];
        for (int i = 0; i < n; ++i) {
            f[i][i] = 1.0f;
        }
        return f;
    }

    public static void multiply(float[] source, float[] dest, int len) {
        for (int k = 0; k < len; ++k) {
            int n = k;
            dest[n] = dest[n] * source[k];
        }
    }

    public static void multiplyElementwise(float[][] source, float[][] dest, int m, int n) {
        for (int i = 0; i < m; ++i) {
            float[] di = dest[i];
            float[] si = source[i];
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                di[n2] = di[n2] * si[j];
            }
        }
    }

    public static void randomize(int[] t, Random r) {
        for (int i = 0; i < t.length - 1; ++i) {
            int j = r.nextInt(t.length - i) + i;
            int tmp = t[i];
            t[i] = t[j];
            t[j] = tmp;
        }
    }

    public static <T> void randomize(T[] t, Random r) {
        for (int i = 0; i < t.length - 1; ++i) {
            int j = r.nextInt(t.length - i) + i;
            T tmp = t[i];
            t[i] = t[j];
            t[j] = tmp;
        }
    }

    public static int[] range(int end) {
        int[] r = new int[end];
        for (int i = 0; i < end; ++i) {
            r[i] = i;
        }
        return r;
    }

    public static void rotateLeft(float[] dest, float[] src, int offset) {
        int x = src.length;
        if ((offset %= x) < 0) {
            offset += x;
        }
        int i = offset;
        int j = 0;
        while (i < x) {
            dest[j] = src[i];
            ++i;
            ++j;
        }
        i = 0;
        j = x - offset;
        while (i < offset) {
            dest[j] = src[i];
            ++i;
            ++j;
        }
    }

    public static void rotateRight(float[] dest, float[] src, int offset) {
        int j;
        int x = src.length;
        if ((offset %= x) < 0) {
            offset += x;
        }
        int i = 0;
        for (j = offset; j < x; ++j) {
            dest[j] = src[i];
            ++i;
        }
        i = x - offset;
        for (j = 0; j < offset; ++j) {
            dest[j] = src[i];
            ++i;
        }
    }

    public static String toString(float[] a) {
        return MatrixTools.toString(a, a.length, floatFormat, floatWidth);
    }

    public static String toString(float[] a, DecimalFormat fmt) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < a.length; ++i) {
            sb.append(fmt.format(a[i]));
            if (i >= a.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(float[] a, DecimalFormat fmt, String widthfmt) {
        return MatrixTools.toString(a, a.length, fmt, widthfmt);
    }

    public static String toString(float[] a, int size) {
        return MatrixTools.toString(a, size, floatFormat, floatWidth);
    }

    public static String toString(float[] a, int size, DecimalFormat fmt, String widthfmt) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < size; ++i) {
            sb.append(String.format(widthfmt, fmt.format(a[i])));
            if (i >= a.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(float[][] a) {
        return MatrixTools.toString(a, a.length, a.length > 0 ? a[0].length : 0, floatFormat, floatWidth);
    }

    public static String toString(float[][] a, int rowSize, int colSize) {
        return MatrixTools.toString(a, rowSize, colSize, floatFormat, floatWidth);
    }

    public static String toString(float[][] a, int rowSize, int colSize, DecimalFormat fmt, String widthfmt) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < rowSize; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(MatrixTools.toString(a[i], colSize, fmt, widthfmt));
            if (i >= a.length - 1) continue;
            sb.append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

