/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Engineer.Gun;

import java.util.LinkedList;
import java.util.ListIterator;
import robocode.AdvancedRobot;
import wcsv.Engineer.Gun.Gun;
import wcsv.Engineer.Utilities.Map;
import wcsv.Engineer.Utilities.Target;
import wcsv.Engineer.Utilities.Utilities;
import wcsv.Engineer.Utilities.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogGun
extends Gun {
    public static final double[] offsets;
    private static final double MIN_GUN_TURN = 0.001;
    public static Map data;
    private static AdvancedRobot robot;
    public static long actualBulletHits;
    public static long actualBulletMisses;
    private double bulletPower;
    private boolean aim;
    private boolean willFireThisTick;
    public LinkedList waves;
    public Wave wave;

    public void operate(Target target, Target source) {
        boolean bl = false;
        if (this.aim && Math.abs(robot.getGunTurnRemainingRadians()) < 0.001) {
            bl = this.willFireThisTick = true;
        }
        if (target.energy > 0.0) {
            this.bulletPower = Math.max(Math.min(600.0 / target.distance, (double)3), (double)2);
            this.bulletPower = Math.min(this.bulletPower, target.energy / (double)4);
            this.bulletPower = Math.min(this.bulletPower, source.energy / (double)5);
            this.wave = new Wave(source, target, this.bulletPower, (int)robot.getTime() - 1, this.willFireThisTick);
            this.waves.add(this.wave);
            ListIterator it = this.waves.listIterator();
            while (it.hasNext()) {
                Wave w = (Wave)it.next();
                double waveDist = w.distanceToPoint(target.location, (int)robot.getTime());
                if (waveDist <= 18.0 && waveDist >= -18.0) {
                    this.update(target, w);
                    continue;
                }
                if (!(waveDist < -18.0)) continue;
                it.remove();
            }
        }
        if (robot.getGunHeat() > robot.getGunCoolingRate()) {
            robot.setTurnGunRightRadians(Utilities.relativeAngle(target.absoluteBearing - robot.getGunHeadingRadians()));
            this.aim = false;
        } else if (this.willFireThisTick && robot.setFireBullet(this.bulletPower) != null) {
            this.aim = false;
        } else {
            robot.setTurnGunRightRadians(Utilities.relativeAngle(this.computeFiringAngle(target, source, this.wave) - robot.getGunHeadingRadians()));
            this.aim = true;
        }
    }

    public void update(Target t, Wave w) {
        double[] vect = this.createVector(w.targetRobot, w);
        Map.Node e = data.add(vect);
        double bearingChange = w.computeCentralBearingChange(t.location) * (double)w.targetRobot.orbitDir;
        double maxEscapeAngle = Utilities.maxEscapeAngle_Velocity(w.velocity);
        int mid = Utilities.getSegment(bearingChange / maxEscapeAngle, offsets);
        double factor = w.isRealBullet ? 1.0 : 0.1;
        Map.Node curr = LogGun.data.head;
        int index = 0;
        while (curr != null) {
            data.combine(vect, curr, 1.0 / Utilities.square(1.0 + (double)Math.abs(index - LogGun.data.lastAddedIndex)), factor, mid);
            ++curr.uses;
            ++index;
            curr = curr.next;
        }
    }

    public double computeFiringAngle(Target target, Target source, Wave w) {
        double[] buff = data.get(this.createVector(target, w));
        if (buff == null || target.energy <= 0.0) {
            return target.absoluteBearing;
        }
        double[] buffer = new double[buff.length];
        int i = 0;
        while (i < buffer.length) {
            int j = 0;
            while (j < buff.length) {
                int n = i;
                buffer[n] = buffer[n] + buff[j] / (1.0 + (double)Math.abs(i - j));
                ++j;
            }
            ++i;
        }
        int mostIndex = (int)((double)offsets.length / (double)2);
        double mostHits = buffer[mostIndex];
        int i2 = 0;
        while (i2 < offsets.length) {
            double hits = buffer[i2];
            if (hits > mostHits) {
                mostIndex = i2;
                mostHits = hits;
            }
            ++i2;
        }
        return Utilities.absoluteAngle(target.absoluteBearing + Utilities.maxEscapeAngle_Velocity(w.velocity) * offsets[mostIndex] * (double)target.orbitDir);
    }

    public double[] createVector(Target t, Wave wave) {
        return new double[]{Math.min(55.0, t.distance / wave.velocity) / 55.0, Math.abs(t.lateralVelocity) / 8.0, Math.abs(t.rollingVelocity) / 8.0, Utilities.wallCollisionAngle(t, wave.sourceRobot.location, 1.0, 1.05) / 1.05, Utilities.wallCollisionAngle(t, wave.sourceRobot.location, -1.0, 0.785) / 0.785};
    }

    public void reset() {
        this.aim = false;
        this.willFireThisTick = false;
        this.waves = new LinkedList();
        System.out.println("Real Bullet Hit %: " + Double.toString((double)actualBulletHits / (double)(actualBulletHits + actualBulletMisses) * 100.0));
        System.out.println("Nodes Used By Gun: " + LogGun.data.size);
    }

    private final /* synthetic */ void this() {
        this.aim = false;
        this.willFireThisTick = false;
    }

    public LogGun(AdvancedRobot r) {
        this.this();
        robot = r;
        data = new Map(5, Math.sqrt(5) / 10.0);
        this.waves = new LinkedList();
        this.bulletPower = 3;
    }

    static {
        double[] dArray = new double[41];
        dArray[0] = -1.0;
        dArray[1] = -0.95;
        dArray[2] = -0.9;
        dArray[3] = -0.85;
        dArray[4] = -0.8;
        dArray[5] = -0.75;
        dArray[6] = -0.7;
        dArray[7] = -0.65;
        dArray[8] = -0.6;
        dArray[9] = -0.55;
        dArray[10] = -0.5;
        dArray[11] = -0.45;
        dArray[12] = -0.4;
        dArray[13] = -0.35;
        dArray[14] = -0.3;
        dArray[15] = -0.25;
        dArray[16] = -0.2;
        dArray[17] = -0.15;
        dArray[18] = -0.1;
        dArray[19] = -0.05;
        dArray[21] = 0.05;
        dArray[22] = 0.1;
        dArray[23] = 0.15;
        dArray[24] = 0.2;
        dArray[25] = 0.25;
        dArray[26] = 0.3;
        dArray[27] = 0.35;
        dArray[28] = 0.4;
        dArray[29] = 0.45;
        dArray[30] = 0.5;
        dArray[31] = 0.55;
        dArray[32] = 0.6;
        dArray[33] = 0.65;
        dArray[34] = 0.7;
        dArray[35] = 0.75;
        dArray[36] = 0.8;
        dArray[37] = 0.85;
        dArray[38] = 0.9;
        dArray[39] = 0.95;
        dArray[40] = 1.0;
        offsets = dArray;
        actualBulletHits = 0L;
        actualBulletMisses = 0L;
    }
}

