/*
 * Decompiled with CFR 0.152.
 */
package jab.targeting;

import jab.module.BotInfo;
import jab.module.Module;
import jab.module.Targeting;
import jab.targeting.CircularTargeting;
import jab.targeting.Visits;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import robocode.Event;
import robocode.MessageEvent;
import robocode.Rules;
import robocode.util.Utils;

public class GuessFactorMelee
extends Targeting {
    static final double BOT_WIDTH = 36.0;
    static final int MAX_VISITS = 255;
    static final int VARIABLE_BINS = 11;
    static final int TARGETING_BINS = 101;
    static final double MAX_ESCAPE_ANGLE = 1.0;
    static final double MAX_DISTANCE = 800.0;
    static int[][][][][] brain;
    int bestOffset = 50;
    int maxVisits = 0;
    int var1_Distance;
    int var2_LateralVelocity;
    int var3_DistanceToWalls;
    Vector<Wave> waves = new Vector();

    public GuessFactorMelee(Module bot) {
        super(bot);
    }

    public void target() {
        if (brain == null) {
            brain = new int[Module.totalNumOfEnemies][11][11][11][101];
        }
        Enumeration<Wave> waveEnum = this.waves.elements();
        while (waveEnum.hasMoreElements()) {
            Wave wave = waveEnum.nextElement();
            wave.updateWave();
            BotInfo waveEnemy = this.bot.botsInfo.get(wave.enemyName);
            if (waveEnemy == null) {
                this.waves.remove(wave);
                continue;
            }
            if (wave.isOnTheCrest(waveEnemy.getBotRectangle())) {
                double thetaFireTime = Utils.normalAbsoluteAngle((double)Math.atan2(wave.enemy.x - wave.origin.x, wave.enemy.y - wave.origin.y));
                double thetaBreak = Utils.normalAbsoluteAngle((double)Math.atan2(waveEnemy.x - wave.origin.x, waveEnemy.y - wave.origin.y));
                double offset = Utils.normalRelativeAngle((double)(thetaFireTime - thetaBreak));
                int targeting_offset = (int)((offset + 1.0) / 0.02);
                targeting_offset = GuessFactorMelee.betweenMinMax(targeting_offset, 0, 100);
                wave.offsets.add(targeting_offset);
                continue;
            }
            if (!wave.isOut(waveEnemy.getBotRectangle())) continue;
            this.updateBrain(wave);
            this.waves.remove(wave);
        }
        if (this.bot.enemy != null) {
            this.calculateSegments(this.bot.botsInfo.get(this.bot.enemy.name));
            this.getTheMostVisitedTargetingBin();
        }
        if (this.bot.getGunHeat() <= 0.1 && this.bot.getEnergy() > 0.0) {
            System.out.println("My prediction for this DataSet(" + this.bot.getEnemyAssignedNum(this.bot.enemy.name) + "," + this.var1_Distance + "," + this.var2_LateralVelocity + "," + this.var3_DistanceToWalls + ")" + "->" + this.bestOffset + "  Visits: " + this.maxVisits);
            this.throwWave();
        }
        if (this.maxVisits != 0) {
            double absoluteBearing = this.bot.getHeadingRadians() + this.bot.enemy.bearingRadians - ((double)this.bestOffset * 1.0 * 2.0 / 100.0 - 1.0);
            this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.bot.getGunHeadingRadians())));
        } else {
            new CircularTargeting(this.bot).target();
        }
    }

    private void getTheMostVisitedTargetingBin() {
        int[] offsetVisits = new int[101];
        offsetVisits = (int[])brain[this.bot.getEnemyAssignedNum(this.bot.enemy.name)][this.var1_Distance][this.var2_LateralVelocity][this.var3_DistanceToWalls].clone();
        Enumeration<BotInfo> botsInfoEnum = this.bot.botsInfo.elements();
        while (botsInfoEnum.hasMoreElements()) {
            BotInfo botInfo = botsInfoEnum.nextElement();
            if (this.bot.enemy.name.equals(botInfo.name) || !this.bot.isTheSameBot(this.bot.enemy.name, botInfo.name)) continue;
            int i = 0;
            while (i < 101) {
                int n = i;
                offsetVisits[n] = offsetVisits[n] + brain[this.bot.getEnemyAssignedNum(botInfo.name)][this.var1_Distance][this.var2_LateralVelocity][this.var3_DistanceToWalls][i];
                ++i;
            }
        }
        this.maxVisits = 0;
        this.bestOffset = 50;
        int i = 0;
        while (i < 101) {
            if (this.maxVisits < offsetVisits[i]) {
                this.maxVisits = offsetVisits[i];
                this.bestOffset = i;
            }
            ++i;
        }
    }

    public void listen(Event e) {
        MessageEvent event;
        if (e instanceof MessageEvent && (event = (MessageEvent)e).getMessage() instanceof Visits) {
            Visits visits = (Visits)event.getMessage();
            int i = 0;
            while (i < 101) {
                int[] nArray = brain[visits.enemyNum][visits.var1][visits.var2][visits.var3];
                int n = i;
                nArray[n] = nArray[n] + visits.vector[i];
                ++i;
            }
        }
    }

    private void throwWave() {
        this.waves.add(new Wave(this.bot.enemy.name, new Point2D.Double(this.bot.getX(), this.bot.getY()), Rules.getBulletSpeed((double)this.bot.bulletPower), new Point2D.Double(this.bot.enemy.x, this.bot.enemy.y), new int[]{this.var1_Distance, this.var2_LateralVelocity, this.var3_DistanceToWalls}));
        Enumeration<BotInfo> botsInfo = this.bot.botsInfo.elements();
        while (botsInfo.hasMoreElements()) {
            BotInfo botInfo = botsInfo.nextElement();
            if (this.bot.isTeammate(botInfo.name) || botInfo.name.equals(this.bot.enemy.name) || !this.bot.isTheSameBot(this.bot.enemy.name, botInfo.name)) continue;
            this.calculateSegments(botInfo);
            this.waves.add(new Wave(botInfo.name, new Point2D.Double(this.bot.getX(), this.bot.getY()), Rules.getBulletSpeed((double)this.bot.bulletPower), botInfo, new int[]{this.var1_Distance, this.var2_LateralVelocity, this.var3_DistanceToWalls}));
        }
    }

    private void calculateSegments(BotInfo botInfo) {
        this.var1_Distance = (int)(Math.min(800.0, botInfo.distance) / 80.0);
        this.var1_Distance = GuessFactorMelee.betweenMinMax(this.var1_Distance, 0, 10);
        double latvel = botInfo.velocity * Math.sin(botInfo.headingRadians - (botInfo.bearingRadians + this.bot.getHeadingRadians()));
        this.var2_LateralVelocity = (int)((latvel += 8.0) / 16.0 * 10.0);
        this.var2_LateralVelocity = GuessFactorMelee.betweenMinMax(this.var2_LateralVelocity, 0, 10);
        this.var3_DistanceToWalls = 10;
        double goX = this.bot.getBattleFieldWidth() / 20.0;
        double goY = this.bot.getBattleFieldHeight() / 20.0;
        double x = this.bot.getBattleFieldWidth() / 2.0;
        double y = this.bot.getBattleFieldHeight() / 2.0;
        double w = 0.0;
        double h = 0.0;
        while (!new Rectangle2D.Double(x, y, w, h).contains(new Point2D.Double(botInfo.x, botInfo.y))) {
            x -= goX;
            y -= goY;
            w += goX * 2.0;
            h += goY * 2.0;
            --this.var3_DistanceToWalls;
        }
        this.var3_DistanceToWalls = GuessFactorMelee.betweenMinMax(this.var3_DistanceToWalls, 0, 10);
    }

    private void updateBrain(Wave wave) {
        int minOffset = Integer.MAX_VALUE;
        int maxOffset = Integer.MIN_VALUE;
        Visits visits = new Visits();
        visits.enemyNum = this.bot.getEnemyAssignedNum(wave.enemyName);
        visits.var1 = wave.vars[0];
        visits.var2 = wave.vars[1];
        visits.var3 = wave.vars[2];
        int i = 0;
        while (i < wave.offsets.size()) {
            int current = wave.offsets.get(i);
            if (current <= minOffset) {
                minOffset = current;
            }
            if (current >= maxOffset) {
                maxOffset = current;
            }
            if (i == 0) {
                int n = current;
                visits.vector[n] = visits.vector[n] + 1;
            }
            if (i < wave.offsets.size() - 1) {
                int w;
                int next = wave.offsets.get(i + 1);
                if (current == next) {
                    int n = current;
                    visits.vector[n] = visits.vector[n] + 1;
                } else if (current < next) {
                    w = current + 1;
                    while (w <= next && w < 101) {
                        int n = w++;
                        visits.vector[n] = visits.vector[n] + 1;
                    }
                } else {
                    w = current - 1;
                    while (w >= next && w >= 0) {
                        int n = w--;
                        visits.vector[n] = visits.vector[n] + 1;
                    }
                }
            }
            ++i;
        }
        int maxVisit = Integer.MIN_VALUE;
        int maxVisitIndex = 0;
        int i2 = 0;
        while (i2 < 101) {
            if (maxVisit < visits.vector[i2]) {
                maxVisit = visits.vector[i2];
                maxVisitIndex = i2;
            }
            if (visits.vector[i2] > 2) {
                visits.vector[i2] = 2;
            }
            if (visits.vector[i2] != 0) {
                int[] nArray = brain[visits.enemyNum][visits.var1][visits.var2][visits.var3];
                int n = i2;
                nArray[n] = nArray[n] + visits.vector[i2];
            }
            ++i2;
        }
        if (maxVisit > 1) {
            int[] nArray = brain[this.bot.getEnemyAssignedNum(wave.enemyName)][wave.vars[0]][wave.vars[1]][wave.vars[2]];
            int n = maxVisitIndex;
            nArray[n] = nArray[n] + 1;
            int n2 = maxVisitIndex;
            visits.vector[n2] = visits.vector[n2] + 1;
        } else if (maxVisit == 1) {
            int[] nArray = brain[this.bot.getEnemyAssignedNum(wave.enemyName)][wave.vars[0]][wave.vars[1]][wave.vars[2]];
            int n = minOffset + (maxOffset - minOffset) / 2;
            nArray[n] = nArray[n] + 1;
            int n3 = minOffset + (maxOffset - minOffset) / 2;
            visits.vector[n3] = visits.vector[n3] + 1;
        }
        try {
            this.bot.broadcastMessage(visits);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int betweenMinMax(int number, int min, int max) {
        int aux = number;
        aux = Math.min(max, Math.max(min, number));
        if (aux != number) {
            System.out.println("ERROR: " + number + " was out of bounds! Min: " + min + " Max: " + max);
        }
        return aux;
    }

    public void onPaint(Graphics2D g) {
        Enumeration<Wave> e = this.waves.elements();
        while (e.hasMoreElements()) {
            Wave wave = e.nextElement();
            if (this.bot.botsInfo.get(wave.enemyName) != null && wave.isOnTheCrest(this.bot.botsInfo.get(wave.enemyName).getBotRectangle())) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLUE);
            }
            g.draw(wave);
        }
    }

    public class Wave
    extends Ellipse2D.Double {
        private static final long serialVersionUID = 1L;
        public String enemyName;
        public double time;
        public Point2D.Double origin;
        public double velocity;
        public Point2D.Double enemy;
        public int[] vars;
        Vector<Integer> offsets;

        public Wave(String enemyName, Point2D.Double origin, double velocity, Point2D.Double enemy, int[] vars) {
            this.enemyName = enemyName;
            this.origin = origin;
            this.velocity = velocity;
            this.time = 0.0;
            this.enemy = enemy;
            this.vars = vars;
            this.x = origin.x - 18.0;
            this.y = origin.y - 18.0;
            this.offsets = new Vector();
        }

        public void updateWave() {
            this.time += 1.0;
            double travelledDistance = this.time * this.velocity;
            this.x = this.origin.x - travelledDistance;
            this.y = this.origin.y - travelledDistance;
            this.width = this.height = travelledDistance * 2.0;
        }

        public boolean isOnTheCrest(Rectangle2D.Double enemyRect) {
            return this.intersects(enemyRect) && !this.isOut(enemyRect);
        }

        public boolean isOut(Rectangle2D.Double enemyRect) {
            Point2D.Double bottomLeft = new Point2D.Double(enemyRect.x, enemyRect.y);
            Point2D.Double bottomRight = new Point2D.Double(enemyRect.x + enemyRect.width, enemyRect.y);
            Point2D.Double upLeft = new Point2D.Double(enemyRect.x, enemyRect.y + enemyRect.height);
            Point2D.Double upRight = new Point2D.Double(enemyRect.x + enemyRect.width, enemyRect.y + enemyRect.height);
            return this.contains(bottomLeft) && this.contains(bottomRight) && this.contains(upLeft) && this.contains(upRight);
        }
    }
}

