/*
 * Decompiled with CFR 0.152.
 */
package md;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.WinEvent;

public class November
extends AdvancedRobot {
    EnemyBehaviour EnB = new EnemyBehaviour();
    MyBullet MyB = new MyBullet();
    EnemyRobot EnR = new EnemyRobot();
    double mMax = 1230.0;
    double ToMove;
    boolean mForward = true;
    double Vb;
    int bFired = 0;
    int bMissed = 0;
    int bMissed2 = 0;
    int bMissedMax = 5;
    double bMissedPerc = 0.7;
    boolean Predict = true;
    int HitWall = 0;
    int HitWallCD = 30;
    int HitWallCD2 = 15;
    int HitWallCD25 = 12;
    double rM;
    double bM;
    double tM;
    double lM;
    double ExtraFire = 3.0;
    double EHead = 0.0;
    double sEHead = 0.0;
    double sEHead2 = 0.0;
    double DiffAng;
    boolean Scanned = false;
    int MLcount = 0;
    double prev_eng = 0.0;
    double GunHeading = 0.0;
    long StuckTime = 50L;
    double sEnRHead;
    boolean ScanNext = false;
    long LastFireTime = 0L;
    boolean FirstScan = true;
    String EnemyName;
    double GloProbabDisp;
    long LastHurt = 0L;
    long LastHit = 0L;
    double addangl;

    public void run() {
        this.setColors(Color.green, Color.green, Color.white);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.ToMove = this.mMax;
        this.rM = this.getBattleFieldWidth() - (double)90;
        this.tM = this.getBattleFieldHeight() - (double)90;
        this.bM = 90.0;
        this.lM = 90.0;
        double sgx = 0.0;
        double sgy = 0.0;
        while (true) {
            if (this.HitWall > 0) {
                --this.HitWall;
            }
            double gx = this.getX();
            double gy = this.getY();
            if (gx < sgx && gx < this.lM || gy < sgy && gy < this.bM || gx > sgx && gx > this.rM || gy > sgy && gy > this.tM) {
                this.HitWall = this.HitWallCD2;
                this.SwitchDir();
            }
            sgx = gx;
            sgy = gy;
            this.StuckTime = gx < this.lM && gy < this.bM || gx < this.lM && gy > this.tM || gx > this.rM && gy < this.bM || gx > this.rM && gy > this.tM ? --this.StuckTime : 50L;
            this.MyB.Reset();
            this.MyB.GetNext();
            this.execute();
            if (this.Scanned) {
                double RadAdj;
                double EnHeadRad = this.SimpAng(57.296 * (this.getHeadingRadians() + this.EnR.getBearingRadians()));
                if (EnHeadRad < 0.0) {
                    EnHeadRad += (double)360;
                }
                if ((RadAdj = 57.296 * this.getRadarHeadingRadians() - EnHeadRad) > 0.0) {
                    if ((RadAdj += (double)22) > (double)45) {
                        RadAdj = 45.0;
                    }
                } else if ((RadAdj -= (double)22) < (double)-45) {
                    RadAdj = -45.0;
                }
                this.setTurnRadarLeft(RadAdj);
            } else {
                this.setTurnRadarRight(45.0);
            }
            if (++this.MLcount <= 2) continue;
            this.Scanned = false;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double ELoss;
        double AAngl = 0.0;
        this.EnR.Detect(e);
        if (this.FirstScan) {
            this.FirstScan = false;
            this.EnemyName = e.getName();
            this.EnB.ReadData();
        }
        if ((ELoss = this.prev_eng - this.EnR.getEnergy()) <= (double)3 && ELoss >= 0.1) {
            this.AvoidBullet();
        }
        this.prev_eng = this.EnR.getEnergy();
        this.MyB.Reset();
        this.MyB.GetNext();
        this.MLcount = 0;
        this.Scanned = true;
        if (new TurnCompleteCondition((AdvancedRobot)this).test()) {
            if (Math.random() < 0.999 && this.StuckTime > (long)0) {
                if (ELoss <= (double)3 && ELoss >= 0.1) {
                    this.addangl = (double)60 - (double)120 * Math.random();
                    this.setTurnRight(this.SimpAng2(this.EnR.getBearing() + (double)90 + this.addangl));
                }
            } else {
                this.StuckTime = 50L;
                if (this.getVelocity() > 0.0) {
                    this.setTurnRight(this.EnR.getBearing());
                } else {
                    this.setTurnRight(this.SimpAng((double)180 + this.EnR.getBearing()));
                }
            }
        }
        this.ExtraFire = (double)1400 / (this.EnR.getDistance() + 1.0);
        if (this.GloProbabDisp < 0.6) {
            this.ExtraFire /= 1.1;
        }
        if (this.LastHurt > (long)0 && this.EnR.getDistance() > (double)350 && this.getTime() - this.LastHit > (long)150 && this.getTime() - this.LastHurt > (long)200) {
            this.ExtraFire /= (double)2;
        }
        if (this.getEnergy() > (double)10 && this.EnR.getEnergy() < (double)15) {
            this.ExtraFire /= 1.4;
        }
        if (this.ExtraFire > (double)3) {
            this.ExtraFire = 3.0;
        }
        if (this.ExtraFire < 0.1) {
            this.ExtraFire = 0.1;
        }
        this.DiffAng = 0.0;
        this.Vb = (double)20 - (double)3 * this.ExtraFire;
        this.LastFireTime = this.getTime();
        if (this.EnB.Find() && this.EnR.getEnergy() > 0.0) {
            this.EHead = this.SimpAng(this.EnR.getHeading() + this.EnB.NextDir);
            if (this.EHead < 0.0) {
                this.EHead += (double)360;
            }
            AAngl = this.SimpAng(this.AdvAng(this.EHead, this.EnB.NextVel));
            this.DiffAng = this.SimpAng(this.getHeading() + this.EnR.getBearing() - this.GunHeading + AAngl);
        } else {
            if (this.EnR.getVelocity() != 0.0 && Math.abs(this.EnR.getHeading() - this.EHead - (this.EHead - this.sEHead)) - Math.abs(this.sEHead - this.sEHead2 - (this.EHead - this.sEHead)) < (double)2) {
                this.sEHead2 = this.sEHead;
                this.sEHead = this.EHead;
                this.EHead = this.EnR.getHeading() + (this.EnR.getHeading() - this.EHead);
            } else {
                this.sEHead2 = this.sEHead;
                this.sEHead = this.EHead;
                this.EHead = this.EnR.getHeading();
            }
            AAngl = this.SimpAng(this.AdvAng(this.EHead, this.EnR.getVelocity())) * this.MyB.CorrectCoef * 1.1;
            if (this.EnR.getVelocity() != 0.0 && Math.abs(AAngl) > 1.0) {
                double tmpEV;
                if (Math.random() < 0.4 && Math.abs(AAngl) > (double)20) {
                    AAngl /= (double)2;
                }
                if ((tmpEV = Math.abs((this.EnR.CosVel + this.EnR.LastCosVel + (double)8) / (double)3)) > (double)8) {
                    tmpEV = 8.0;
                }
                double LurkCoef = 1.0;
                if (this.EnR.CosVel * this.EnR.LastCosVel <= 0.0 || Math.abs(this.EnR.getVelocity()) < Math.abs(this.EnR.LastVel)) {
                    LurkCoef = 1.2;
                }
                if (Math.abs(57.296 * Math.atan(tmpEV / this.Vb)) < Math.abs(LurkCoef * AAngl) && (double)this.getTime() - this.sEnRHead < (double)15) {
                    AAngl /= 1.3;
                }
                if (this.ScanNext) {
                    AAngl = Math.random() < 0.5 ? (AAngl /= (double)4) : -AAngl / (double)4;
                }
            } else if (this.EnR.getEnergy() > 0.0) {
                AAngl += this.MyB.CorrectedAngle;
            }
            if (this.EnR.getDistance() < (double)250 && Math.abs(this.EnR.LastVel) > Math.abs(this.EnR.getVelocity()) && Math.abs(this.EnR.CosVel) < (double)4) {
                this.DiffAng = this.EnR.getVelocity() < 0.0 ? this.SimpAng(this.getHeading() + this.EnR.getBearing() - this.GunHeading - (double)15) : this.SimpAng(this.getHeading() + this.EnR.getBearing() - this.GunHeading + (double)15);
                this.GunHeading = (this.GunHeading + this.DiffAng) % (double)360;
                this.turnGunRight(this.SimpAng(this.GunHeading - this.getGunHeading()));
                this.GunHeading = this.getGunHeading();
                this.MyFire(1.0);
                return;
            }
            this.DiffAng = this.SimpAng(this.getHeading() + this.EnR.getBearing() - this.GunHeading + AAngl);
            if ((double)this.getTime() - this.sEnRHead < (double)10) {
                double DisperceA = 57.296 * Math.atan((double)40 / this.EnR.getDistance());
                this.DiffAng += DisperceA * (Math.random() - 0.5);
            }
        }
        this.GunHeading = (this.GunHeading + this.DiffAng) % (double)360;
        if (this.getGunHeat() != 0.0) {
            this.setTurnGunRight(this.DiffAng);
            return;
        }
        if (this.EstBX(AAngl) < 0.0 || this.EstBX(AAngl) > this.getBattleFieldWidth() || this.EstBY(AAngl) < 0.0 || this.EstBY(AAngl) > this.getBattleFieldHeight()) {
            this.setTurnGunRight(this.DiffAng);
            return;
        }
        this.turnGunRight(this.SimpAng(this.GunHeading - this.getGunHeading()));
        this.GunHeading = this.getGunHeading();
        this.MyFire(this.ExtraFire);
        this.MyB.Add(AAngl);
        this.sEnRHead = this.getTime();
        this.execute();
    }

    public void onHitWall(HitWallEvent e) {
        this.ToMove = this.mMax;
        this.HitWall = this.HitWallCD;
        this.SwitchDir();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.LastHurt = this.getTime();
        this.prev_eng += e.getPower() * (double)3;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.LastHit = this.getTime();
        this.prev_eng = e.getEnergy();
        this.bMissed = 0;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        if (++this.bMissed2 > this.bMissedMax && (double)this.bMissed2 > this.bMissedPerc * (double)this.bFired) {
            this.Predict = !this.Predict;
            this.bFired = 0;
            this.bMissed2 = 0;
        }
    }

    public final double SimpAng(double angle) {
        double fixedAngle;
        if (angle > (double)-180 && angle <= (double)180) {
            return angle;
        }
        for (fixedAngle = angle; fixedAngle <= (double)-180; fixedAngle += (double)360) {
        }
        while (fixedAngle > (double)180) {
            fixedAngle -= (double)360;
        }
        return fixedAngle;
    }

    public final double SimpAng2(double angle) {
        double fixedAngle;
        if (angle > (double)-90 && angle <= (double)90) {
            return angle;
        }
        for (fixedAngle = angle; fixedAngle <= (double)-90; fixedAngle += (double)180) {
        }
        while (fixedAngle > (double)90) {
            fixedAngle -= (double)180;
        }
        return fixedAngle;
    }

    public final void SwitchDir() {
        double tm = this.HitWall != 0 ? this.ToMove : -this.ToMove;
        this.setMaxVelocity(8.0);
        if (this.mForward) {
            this.setBack(tm);
        } else {
            this.setAhead(tm);
        }
        this.mForward = !this.mForward;
    }

    public final double AdvAng(double beta, double Ve) {
        double alpha = (double)360 - this.GunHeading;
        double gamma = (double)180 - alpha - beta;
        double AAng = 57.296 * Math.asin(Ve / this.Vb * Math.sin(gamma / 57.296));
        return AAng;
    }

    public final void AvoidBullet() {
        if (this.HitWall == 0) {
            double tm = (double)100 + (double)30 * Math.random();
            if (this.EnR.getDistance() > (double)250) {
                tm /= 1.3;
            }
            this.setMaxVelocity(8.0);
            if (Math.random() < 0.5) {
                tm = -tm;
            }
            this.setAhead(tm);
        }
    }

    public final double EstBX(double AdvAngle) {
        double Vb = (double)20 - (double)3 * this.ExtraFire;
        double EstDist = (this.EnR.getDistance() - (double)40) / Math.cos(AdvAngle / 57.296);
        return this.getX() + EstDist * Math.sin(this.GunHeading / 57.296);
    }

    public final double EstBY(double AdvAngle) {
        double Vb = (double)20 - (double)3 * this.ExtraFire;
        double EstDist = (this.EnR.getDistance() - (double)40) / Math.cos(AdvAngle / 57.296);
        return this.getY() + EstDist * Math.cos(this.GunHeading / 57.296);
    }

    public void MyFire(double Power) {
        if (this.getEnergy() > Power) {
            this.setFire(Power);
            this.LastFireTime = this.getTime();
            this.EnB.Add();
            ++this.bFired;
        } else if (this.getEnergy() > 0.3) {
            this.setFire(0.3);
            this.LastFireTime = this.getTime();
            this.EnB.Add();
            ++this.bFired;
        } else if (this.getEnergy() >= 0.1 && this.EnR.getEnergy() < 1.0 && this.EnR.getVelocity() == 0.0) {
            this.setFire(0.1);
            this.LastFireTime = this.getTime();
            this.EnB.Add();
            ++this.bFired;
        }
        if (Power == 0.0) {
            this.LastFireTime = 0L;
        }
    }

    public void onWin(WinEvent event) {
        this.EnB.WriteData();
    }

    public void onDeath(DeathEvent event) {
        this.EnB.WriteData();
    }

    public class EnemyRobot {
        ScannedRobotEvent LastRobot;
        double X;
        double Y;
        double LastVel = 0.0;
        double LastCosVel = 0.0;
        double CosVel = 0.0;

        public void Detect(ScannedRobotEvent e) {
            if (November.this.EnR.X != 0.0) {
                this.LastVel = this.LastRobot.getVelocity();
            }
            this.LastRobot = e;
            this.X = November.this.getX() + this.LastRobot.getDistance() * Math.sin(November.this.getHeadingRadians() + this.LastRobot.getBearingRadians());
            this.Y = November.this.getY() + this.LastRobot.getDistance() * Math.cos(November.this.getHeadingRadians() + this.LastRobot.getBearingRadians());
            this.LastCosVel = this.CosVel;
            this.CosVel = this.LastRobot.getVelocity() * Math.cos(November.this.getHeadingRadians() - this.LastRobot.getHeadingRadians());
        }

        public double getHeading() {
            if (November.this.EnR.getVelocity() > 0.0) {
                return this.LastRobot.getHeading();
            }
            return -this.LastRobot.getHeading();
        }

        public int IsAcc() {
            if (this.LastRobot.getVelocity() > this.LastVel) {
                return 1;
            }
            if (this.LastRobot.getVelocity() < this.LastVel) {
                return -1;
            }
            return 0;
        }

        public double getBearing() {
            return this.LastRobot.getBearing();
        }

        public double getDistance() {
            return this.LastRobot.getDistance();
        }

        public double getEnergy() {
            return this.LastRobot.getEnergy();
        }

        public double getVelocity() {
            return this.LastRobot.getVelocity();
        }

        public double getBearingRadians() {
            return this.LastRobot.getBearingRadians();
        }
    }

    public class MyBullet {
        int count = 0;
        int freecell = 0;
        int max = 10;
        double[] iX = new double[this.max];
        double[] iY = new double[this.max];
        double[] iA = new double[this.max];
        double[] iT = new double[this.max];
        double[] eT = new double[this.max];
        double[] Vb = new double[this.max];
        double[] AA = new double[this.max];
        double CorrectedAngle = 0.0;
        double CorrectCoef = 1.0;
        double s1CC = 1.0;
        double s2CC = 1.0;
        double s3CC = 1.0;
        double sCorrectedAngle = 0.0;

        public boolean FindBullet(double EnR_X, double EnR_Y, double Dist) {
            boolean FoundBullet = false;
            for (int i = 0; i < this.max; ++i) {
                if (!(Math.sqrt((November.this.EnR.X - this.X(i)) * (November.this.EnR.X - this.X(i)) + (November.this.EnR.Y - this.Y(i)) * (November.this.EnR.Y - this.Y(i))) < Dist)) continue;
                FoundBullet = true;
                break;
            }
            return FoundBullet;
        }

        public double X(int tcount) {
            return this.iX[tcount] + this.Dist(tcount) * Math.sin(this.iA[tcount]);
        }

        public double Y(int tcount) {
            return this.iY[tcount] + this.Dist(tcount) * Math.cos(this.iA[tcount]);
        }

        public double Dist(int tcount) {
            return ((double)November.this.getTime() - this.iT[tcount]) * this.Vb[tcount];
        }

        public double CorAng() {
            double BulletAng;
            if (November.this.EnR.X == this.iX[this.count]) {
                return 0.0;
            }
            if (this.X(this.count) == this.iX[this.count]) {
                return 0.0;
            }
            double RBDist = Math.sqrt((November.this.EnR.X - this.X(this.count)) * (November.this.EnR.X - this.X(this.count)) + (November.this.EnR.Y - this.Y(this.count)) * (November.this.EnR.Y - this.Y(this.count)));
            double RobotAng = 57.296 * Math.atan((November.this.EnR.Y - this.iY[this.count]) / (November.this.EnR.X - this.iX[this.count]));
            double DeltaAng = RobotAng - (BulletAng = 57.296 * Math.atan((this.Y(this.count) - this.iY[this.count]) / (this.X(this.count) - this.iX[this.count])));
            if (Math.abs(DeltaAng) > (double)80) {
                DeltaAng = 0.0;
            }
            return -DeltaAng;
        }

        public void Add(double AdvAngle) {
            this.FindFreeCell();
            this.iX[this.freecell] = November.this.getX();
            this.iY[this.freecell] = November.this.getY();
            this.iA[this.freecell] = November.this.GunHeading / 57.296;
            this.iT[this.freecell] = November.this.getTime();
            this.Vb[this.freecell] = (double)20 - (double)3 * November.this.ExtraFire;
            this.AA[this.freecell] = AdvAngle != 0.0 ? AdvAngle : 1.0E-5;
            double EstDist = (November.this.EnR.getDistance() - 0.0) / Math.cos(this.AA[this.freecell] / 57.296);
            this.eT[this.freecell] = (double)November.this.getTime() + EstDist / this.Vb[this.freecell];
        }

        public void Reset() {
            this.count = -1;
        }

        public void Free() {
            this.eT[this.count] = 0.0;
        }

        public boolean GetNext() {
            November.this.ScanNext = false;
            ++this.count;
            if (this.count >= this.max) {
                return false;
            }
            if (this.eT[this.count] == 0.0) {
                return this.GetNext();
            }
            if ((double)November.this.getTime() < this.eT[this.count]) {
                return this.GetNext();
            }
            if (Math.abs(this.CorAng() - this.sCorrectedAngle) > (double)50) {
                November.this.ScanNext = true;
            } else {
                this.CorrectedAngle = this.CorAng();
                this.CorrectCoef = this.AA[this.count] != 0.0 ? (this.AA[this.count] + this.CorrectedAngle) / this.AA[this.count] : 1.0;
                if (Math.abs(this.CorrectCoef) > 1.5) {
                    this.CorrectCoef = 1.0;
                }
                if (November.this.EnR.getDistance() < (double)250) {
                    if (this.s1CC > 0.0 && this.s3CC > 0.0 && this.s2CC < 0.0 && this.CorrectCoef < 0.0) {
                        this.CorrectCoef = -this.CorrectCoef / (double)2;
                    }
                    if (this.s1CC < 0.0 && this.s3CC < 0.0 && this.s2CC > 0.0 && this.CorrectCoef > 0.0) {
                        this.CorrectCoef = -this.CorrectCoef / (double)2;
                    }
                }
                this.s3CC = this.s2CC;
                this.s2CC = this.s1CC;
                this.s1CC = this.CorrectCoef;
            }
            this.sCorrectedAngle = this.CorAng();
            this.Free();
            return true;
        }

        void FindFreeCell() {
            this.freecell = 0;
            for (int ii = 0; ii < this.max; ++ii) {
                if (this.eT[ii] != 0.0) continue;
                this.freecell = ii;
                break;
            }
        }
    }

    public class EnemyBehaviour {
        int PredDisp = 1;
        int AddC = -1;
        int max = 3000;
        int Filled = 0;
        double[] EnVel = new double[this.max];
        double[] EnDir = new double[this.max];
        double[] EnDist = new double[this.max];
        int[] EnAcc = new int[this.max];
        boolean[] JustFired = new boolean[this.max];
        boolean[] NearBullet = new boolean[this.max];
        boolean[] NearWall = new boolean[this.max];
        double NextVel = 0.0;
        double NextDir = 0.0;
        boolean Found = false;

        public void ReadData() {
            int i = 0;
            try {
                DataInputStream DataIS = new DataInputStream(new FileInputStream(November.this.getDataFile("EnLog.dat")));
                ((Robot)November.this).out.println("Read");
                String FEName = DataIS.readUTF();
                if (November.this.EnemyName.compareTo(FEName) != 0) {
                    ((Robot)November.this).out.println("Wrong bot");
                    return;
                }
                for (i = 0; i < this.max; ++i) {
                    this.EnVel[i] = DataIS.readDouble();
                    this.EnDir[i] = DataIS.readDouble();
                    this.EnDist[i] = DataIS.readDouble();
                    this.EnAcc[i] = DataIS.readInt();
                    this.JustFired[i] = DataIS.readBoolean();
                    this.NearBullet[i] = DataIS.readBoolean();
                    this.NearWall[i] = DataIS.readBoolean();
                    if (this.EnDist[i] != 0.0) continue;
                    this.AddC = i - 1;
                    break;
                }
                DataIS.close();
                this.Filled = i;
                ((Robot)November.this).out.println("Read OK: ".concat(String.valueOf(String.valueOf(i))));
            }
            catch (IOException e) {
                ((Robot)November.this).out.println("Read Exception");
            }
        }

        public void WriteData() {
            try {
                DataOutputStream DataOS = new DataOutputStream((OutputStream)new RobocodeFileOutputStream(November.this.getDataFile("EnLog.dat")));
                ((Robot)November.this).out.println("Write");
                DataOS.writeUTF(November.this.EnemyName);
                for (int i = 0; i < this.max; ++i) {
                    DataOS.writeDouble(this.EnVel[i]);
                    DataOS.writeDouble(this.EnDir[i]);
                    DataOS.writeDouble(this.EnDist[i]);
                    DataOS.writeInt(this.EnAcc[i]);
                    DataOS.writeBoolean(this.JustFired[i]);
                    DataOS.writeBoolean(this.NearBullet[i]);
                    DataOS.writeBoolean(this.NearWall[i]);
                    if (this.EnDist[i] == 0.0) break;
                }
                DataOS.close();
            }
            catch (IOException e) {
                ((Robot)November.this).out.println("Write Exception");
            }
        }

        public void Add() {
            if (++this.AddC >= this.max) {
                this.AddC = 0;
            }
            if (this.Filled < this.AddC) {
                this.Filled = this.AddC;
            }
            this.EnVel[this.AddC] = Math.abs(November.this.EnR.getVelocity());
            this.EnDir[this.AddC] = November.this.EnR.getHeading();
            this.EnDist[this.AddC] = November.this.EnR.getDistance();
            this.EnAcc[this.AddC] = November.this.EnR.IsAcc();
            this.JustFired[this.AddC] = November.this.getTime() - November.this.LastFireTime < (long)3;
            this.NearBullet[this.AddC] = November.this.MyB.FindBullet(November.this.EnR.X, November.this.EnR.Y, 130.0);
            this.NearWall[this.AddC] = November.this.EnR.X < November.this.lM || November.this.EnR.Y < November.this.bM || November.this.EnR.X > November.this.rM || November.this.EnR.Y > November.this.tM;
        }

        public boolean Find() {
            double EVel = Math.abs(November.this.EnR.getVelocity());
            double EDir = November.this.EnR.getHeading();
            double EDist = November.this.EnR.getDistance();
            int EAcc = November.this.EnR.IsAcc();
            double TVel = 0.0;
            double TDir = 0.0;
            int VelC = 0;
            int DistC = 0;
            int AccC = 0;
            int FireC = 0;
            int NearBC = 0;
            int NearWC = 0;
            double counted = 0.0;
            double GloCoef = 0.0;
            long NumCount = 0L;
            int i = 0;
            boolean EJustFired = November.this.getTime() - November.this.LastFireTime <= (long)3;
            boolean ENearBullet = November.this.MyB.FindBullet(November.this.EnR.X, November.this.EnR.Y, 100.0);
            boolean ENearWall = November.this.EnR.X < November.this.lM / (double)2 || November.this.EnR.Y < November.this.bM / (double)2 || November.this.EnR.X > November.this.rM / (double)2 || November.this.EnR.Y > November.this.tM / (double)2;
            this.Found = false;
            for (i = 0; i < this.max && this.EnDist[i] != 0.0; ++i) {
                if (i == this.AddC) continue;
                VelC = this.EnVel[i] == EVel ? 10 : (Math.abs(this.EnVel[i] - EVel) == 1.0 ? 9 : (Math.abs(this.EnVel[i] - EVel) == (double)2 ? 8 : (EVel != 0.0 ? 4 : 1)));
                DistC = Math.abs(this.EnDist[i] - EDist) < (double)400 ? 0 : 0;
                AccC = this.EnAcc[i] == EAcc ? 10 : (EAcc == 0 ? 7 : 0);
                FireC = this.JustFired[i] == EJustFired ? 0 : 0;
                NearBC = this.NearBullet[i] == ENearBullet ? 10 : 0;
                NearWC = this.NearWall[i] == ENearWall ? 0 : 0;
                GloCoef = VelC + DistC + AccC + FireC + NearBC + NearWC;
                counted += GloCoef;
                ++NumCount;
                this.PredDisp = i + 1;
                if (this.PredDisp >= this.max) {
                    this.PredDisp -= this.max;
                }
                if (this.EnDist[this.PredDisp] == 0.0) break;
                TVel += GloCoef * this.EnVel[this.PredDisp];
                TDir += GloCoef * (this.EnDir[this.PredDisp] - this.EnDir[i]);
            }
            November.this.GloProbabDisp = counted / (double)NumCount / (double)30;
            if (counted != 0.0 && November.this.EnB.Filled > 40) {
                this.NextVel = TVel / counted;
                this.NextDir = TDir / counted;
                this.Found = true;
            }
            return this.Found;
        }
    }
}

